/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedClassMeta;
import org.apache.juneau.MetaProvider;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.apache.juneau.xml.annotation.XmlSchema;

public class XmlClassMeta
extends ExtendedClassMeta {
    private final Namespace namespace;
    private final List<Xml> xmls;
    private final XmlFormat format;
    private final String childName;

    public XmlClassMeta(ClassMeta<?> cm, XmlMetaProvider mp) {
        super(cm);
        this.namespace = XmlClassMeta.findNamespace(cm, mp);
        this.xmls = cm.getAnnotations(Xml.class);
        String _childName = null;
        XmlFormat _format = XmlFormat.DEFAULT;
        for (Xml a : this.xmls) {
            if (a.format() != XmlFormat.DEFAULT) {
                _format = a.format();
            }
            if (a.childName().isEmpty()) continue;
            _childName = a.childName();
        }
        this.format = _format;
        this.childName = _childName;
    }

    protected List<Xml> getAnnotations() {
        return this.xmls;
    }

    protected XmlFormat getFormat() {
        return this.format;
    }

    protected String getChildName() {
        return this.childName;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    private static Namespace findNamespace(ClassMeta<?> cm, MetaProvider mp) {
        if (cm == null) {
            return null;
        }
        List<Xml> xmls = cm.getAnnotations(Xml.class);
        List<XmlSchema> schemas = cm.getAnnotations(XmlSchema.class);
        return XmlUtils.findNamespace(xmls, schemas);
    }
}

