/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.internal.Cache;

@Header(value="X-Client-Version")
public class ClientVersion
extends BasicStringHeader {
    private static final long serialVersionUID = 1L;
    private static final Cache<String, ClientVersion> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);

    public static ClientVersion of(String value) {
        if (value == null) {
            return null;
        }
        ClientVersion x = CACHE.get(value);
        if (x == null) {
            x = CACHE.put(value, new ClientVersion(value));
        }
        return x;
    }

    public static ClientVersion of(Object value) {
        if (value == null) {
            return null;
        }
        return new ClientVersion(value);
    }

    public static ClientVersion of(Supplier<?> value) {
        if (value == null) {
            return null;
        }
        return new ClientVersion(value);
    }

    public ClientVersion(Object value) {
        super("X-Client-Version", value);
    }

    public ClientVersion(String value) {
        this((Object)value);
    }
}

