/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;

public final class RestCallException
extends IOException {
    private static final long serialVersionUID = 1L;
    private int responseCode;
    private String response;
    private String responseStatusMessage;
    HttpResponseException e;
    private HttpResponse httpResponse;
    private String serverExceptionName;
    private String serverExceptionMessage;
    private String serverExceptionTrace;

    public RestCallException(String message, Object ... args) {
        super(StringUtils.format(message, args));
    }

    public RestCallException(Throwable cause, String message, Object ... args) {
        this(RestCallException.getMessage(cause, message, null), args);
        this.initCause(cause);
    }

    public RestCallException(Exception e) {
        super(e.getLocalizedMessage(), e);
        Pattern p;
        Matcher m;
        if (e instanceof FileNotFoundException) {
            this.responseCode = 404;
        } else if (e.getMessage() != null && (m = (p = Pattern.compile("[^\\d](\\d{3})[^\\d]")).matcher(e.getMessage())).find()) {
            this.responseCode = Integer.parseInt(m.group(1));
        }
        this.setStackTrace(e.getStackTrace());
    }

    public RestCallException(String msg, HttpResponse response) throws IOException {
        super(StringUtils.format("{0}\n{1}\nstatus=''{2}''\nResponse: \n{3}", msg, response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)IOUtils.UTF8)));
    }

    public RestCallException(int responseCode, String responseMsg, String method, URI url, String response) {
        super(StringUtils.format("HTTP method ''{0}'' call to ''{1}'' caused response code ''{2}, {3}''.\nResponse: \n{4}", method, url, responseCode, responseMsg, response));
        this.responseCode = responseCode;
        this.responseStatusMessage = responseMsg;
        this.response = response;
    }

    protected RestCallException setServerException(Header exceptionName, Header exceptionMessage, Header exceptionTrace) {
        if (exceptionName != null) {
            this.serverExceptionName = exceptionName.getValue();
        }
        if (exceptionMessage != null) {
            this.serverExceptionMessage = exceptionMessage.getValue();
        }
        if (exceptionTrace != null) {
            this.serverExceptionTrace = exceptionTrace.getValue();
        }
        return this;
    }

    protected void throwServerException(ClassLoader cl, Class<?> ... throwables) throws Throwable {
        if (this.serverExceptionName != null) {
            for (Class<?> t : throwables) {
                if (!t.getName().endsWith(this.serverExceptionName)) continue;
                this.doThrow(t, this.serverExceptionMessage);
            }
            try {
                ClassInfo t = ClassInfo.of(cl.loadClass(this.serverExceptionName));
                if (t.isChildOf(RuntimeException.class) || t.isChildOf(Error.class)) {
                    this.doThrow(t.inner(), this.serverExceptionMessage);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void doThrow(Class<?> t, String msg) throws Throwable {
        ConstructorInfo c = null;
        ClassInfo ci = ClassInfo.of(t);
        if (msg != null) {
            c = ci.getPublicConstructor(String.class);
            if (c != null) {
                throw (Throwable)c.invoke(msg);
            }
            c = ci.getPublicConstructor(Object.class);
            if (c != null) {
                throw (Throwable)c.invoke(msg);
            }
        }
        if ((c = ci.getPublicConstructor(new Class[0])) != null) {
            throw (Throwable)c.invoke(new Object[0]);
        }
    }

    protected RestCallException setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.response;
    }

    public String getResponseStatusMessage() {
        return this.responseStatusMessage;
    }

    protected static final String getMessage(Throwable cause, String msg, String def) {
        if (msg != null) {
            return msg;
        }
        if (cause != null) {
            return cause.getMessage();
        }
        return def;
    }
}

