/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.core.ConvertException;
import org.apache.jmeter.report.core.StringConverter;

public final class Converters {
    private static final Map<Class<?>, StringConverter<?>> CONVERTER_MAP = new HashMap();

    private Converters() {
    }

    public static <T> StringConverter<T> getConverter(Class<T> clazz) {
        return CONVERTER_MAP.get(clazz);
    }

    public static <T> T convert(Class<T> clazz, String value) throws ConvertException {
        String result;
        if (clazz.isAssignableFrom(String.class)) {
            String temp;
            result = temp = value;
        } else {
            StringConverter<T> converter = Converters.getConverter(clazz);
            if (converter == null) {
                throw new ConvertException(value, clazz.getName());
            }
            result = converter.convert(value);
        }
        return (T)result;
    }

    static {
        StringConverter<Character> characterConverter = value -> {
            try {
                return Character.valueOf(value.charAt(0));
            }
            catch (NumberFormatException ex) {
                throw new ConvertException(value, Character.class.getName(), ex);
            }
        };
        CONVERTER_MAP.put(Character.class, characterConverter);
        CONVERTER_MAP.put(Character.TYPE, characterConverter);
        StringConverter<Double> doubleConverter = value -> {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new ConvertException(value, Double.class.getName(), ex);
            }
        };
        CONVERTER_MAP.put(Double.class, doubleConverter);
        CONVERTER_MAP.put(Double.TYPE, doubleConverter);
        StringConverter<Float> floatConverter = value -> {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new ConvertException(value, Float.class.getName(), ex);
            }
        };
        CONVERTER_MAP.put(Float.class, floatConverter);
        CONVERTER_MAP.put(Float.TYPE, floatConverter);
        StringConverter<Integer> integerConverter = value -> {
            try {
                return Integer.valueOf(value.trim());
            }
            catch (NumberFormatException ex) {
                throw new ConvertException(value, Integer.class.getName(), ex);
            }
        };
        CONVERTER_MAP.put(Integer.class, integerConverter);
        CONVERTER_MAP.put(Integer.TYPE, integerConverter);
        StringConverter<Long> longConverter = value -> {
            try {
                return Long.valueOf(value.trim());
            }
            catch (NumberFormatException ex) {
                throw new ConvertException(value, Long.class.getName(), ex);
            }
        };
        CONVERTER_MAP.put(Long.class, longConverter);
        CONVERTER_MAP.put(Long.TYPE, longConverter);
        StringConverter<Boolean> booleanConverter = Boolean::valueOf;
        CONVERTER_MAP.put(Boolean.class, booleanConverter);
        CONVERTER_MAP.put(Boolean.TYPE, booleanConverter);
        CONVERTER_MAP.put(File.class, File::new);
    }
}

