/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.jmeter.engine.util.FunctionParser;
import org.apache.jmeter.engine.util.SimpleVariable;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.LogAndIgnoreServiceLoadExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundVariable
implements Function {
    private static final Logger log = LoggerFactory.getLogger(CompoundVariable.class);
    private String rawParameters;
    private static final FunctionParser functionParser = new FunctionParser();
    private static final Map<String, Class<? extends Function>> functions = new HashMap<String, Class<? extends Function>>();
    private boolean hasFunction = false;
    private boolean isDynamic;
    private String permanentResults;
    private ArrayList<Object> compiledComponents = new ArrayList();

    public CompoundVariable() {
    }

    public CompoundVariable(String parameters) {
        this();
        try {
            this.setParameters(parameters);
        }
        catch (InvalidVariableException e) {
            log.debug("Invalid variable: {}", (Object)parameters, (Object)e);
        }
    }

    public String execute() {
        if (this.isDynamic || this.permanentResults == null) {
            JMeterContext context = JMeterContextService.getContext();
            SampleResult previousResult = context.getPreviousResult();
            Sampler currentSampler = context.getCurrentSampler();
            return this.execute(previousResult, currentSampler);
        }
        return this.permanentResults;
    }

    public String getRawParameters() {
        return this.rawParameters;
    }

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) {
        if (this.compiledComponents == null || this.compiledComponents.isEmpty()) {
            return "";
        }
        StringBuilder results = new StringBuilder();
        for (Object item : this.compiledComponents) {
            if (item instanceof Function) {
                try {
                    results.append(((Function)item).execute(previousResult, currentSampler));
                }
                catch (InvalidVariableException e) {
                    log.debug("Invalid variable: {}", item, (Object)e);
                }
                continue;
            }
            if (item instanceof SimpleVariable) {
                results.append(((SimpleVariable)item).toString());
                continue;
            }
            results.append(item);
        }
        if (!this.isDynamic) {
            this.permanentResults = results.toString();
        }
        return results.toString();
    }

    public CompoundVariable getFunction() {
        CompoundVariable func = new CompoundVariable();
        func.compiledComponents = (ArrayList)this.compiledComponents.clone();
        func.rawParameters = this.rawParameters;
        func.hasFunction = this.hasFunction;
        func.isDynamic = this.isDynamic;
        return func;
    }

    @Override
    public List<String> getArgumentDesc() {
        return new ArrayList<String>();
    }

    public void clear() {
        this.hasFunction = false;
        this.compiledComponents.clear();
    }

    public void setParameters(String parameters) throws InvalidVariableException {
        this.rawParameters = parameters;
        if (parameters == null || parameters.length() == 0) {
            return;
        }
        this.compiledComponents = functionParser.compileString(parameters);
        if (this.compiledComponents.size() > 1 || !(this.compiledComponents.get(0) instanceof String)) {
            this.hasFunction = true;
        }
        this.permanentResults = null;
        this.isDynamic = false;
        for (Object item : this.compiledComponents) {
            if (!(item instanceof Function) && !(item instanceof SimpleVariable)) continue;
            this.isDynamic = true;
            break;
        }
    }

    static Object getNamedFunction(String functionName) throws InvalidVariableException {
        if (functions.containsKey(functionName)) {
            try {
                return functions.get(functionName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.error("Exception occurred while instantiating a function: {}", (Object)functionName, (Object)e);
                throw new InvalidVariableException(e);
            }
        }
        return new SimpleVariable(functionName);
    }

    public static Class<? extends Function> getFunctionClass(String className) {
        return functions.get(className);
    }

    public static String[] getFunctionNames() {
        return functions.keySet().toArray(new String[functions.size()]);
    }

    public boolean hasFunction() {
        return this.hasFunction;
    }

    @Override
    public String getReferenceKey() {
        return "";
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
    }

    static {
        try {
            String contain = JMeterUtils.getProperty("classfinder.functions.contain");
            String notContain = JMeterUtils.getProperty("classfinder.functions.notContain");
            if (contain != null) {
                log.info("Note: Function class names must contain the string: '{}'", (Object)contain);
            }
            if (notContain != null) {
                log.info("Note: Function class names must not contain the string: '{}'", (Object)notContain);
            }
            for (Function function : JMeterUtils.loadServicesAndScanJars(Function.class, ServiceLoader.load(Function.class), Thread.currentThread().getContextClassLoader(), new LogAndIgnoreServiceLoadExceptionHandler(log))) {
                String referenceKey = function.getReferenceKey();
                if (referenceKey.length() <= 0) continue;
                functions.put(referenceKey, function.getClass());
            }
            if (functions.isEmpty()) {
                log.warn("Did not find any functions");
            } else {
                log.debug("Function count: {}", (Object)functions.size());
            }
        }
        catch (Exception err) {
            log.error("Exception occurred in static initialization of CompoundVariable.", (Throwable)err);
        }
    }
}

