/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util.graphics;

import com.github.weisj.darklaf.util.graphics.ScaledImage;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;

public final class ImagePainter {
    public static void drawImage(Graphics g, Image image, int x, int y, ImageObserver observer) {
        ImagePainter.drawImage(g, image, new Rectangle(x, y, -1, -1), null, null, observer);
    }

    static void drawImage(Graphics g, Image image, int x, int y, int width, int height, BufferedImageOp op, ImageObserver observer) {
        Rectangle srcBounds = width >= 0 && height >= 0 ? new Rectangle(x, y, width, height) : null;
        ImagePainter.drawImage(g, image, new Rectangle(x, y, width, height), srcBounds, op, observer);
    }

    public static void drawImage(Graphics g, Image image, Rectangle dstBounds, ImageObserver observer) {
        ImagePainter.drawImage(g, image, dstBounds, null, null, observer);
    }

    public static void drawImage(Graphics g, Image image, Rectangle dstBounds, Rectangle srcBounds, ImageObserver observer) {
        ImagePainter.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(Graphics g, Image image, Rectangle dstBounds, Rectangle srcBounds, BufferedImageOp op, ImageObserver observer) {
        int userWidth = image.getWidth(observer);
        int userHeight = image.getHeight(observer);
        int dx = 0;
        int dy = 0;
        int dw = -1;
        int dh = -1;
        if (dstBounds != null) {
            dx = dstBounds.x;
            dy = dstBounds.y;
            dw = dstBounds.width;
            dh = dstBounds.height;
        }
        boolean hasDstSize = dw >= 0 && dh >= 0;
        Graphics invG = null;
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (image instanceof ScaledImage) {
            ScaledImage scaledImage = (ScaledImage)image;
            BufferedImage delegate = scaledImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            scaleX = scaledImage.getScaleX();
            scaleY = scaledImage.getScaleY();
            userWidth = (int)((double)userWidth / scaleX);
            userHeight = (int)((double)userHeight / scaleY);
            AffineTransform tx = ((Graphics2D)g).getTransform();
            if (scaleX == tx.getScaleX() && scaleY == tx.getScaleY()) {
                double gScaleX = tx.getScaleX();
                double gScaleY = tx.getScaleY();
                tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
                tx.translate((double)dx * gScaleX, (double)dy * gScaleY);
                dy = 0;
                dx = 0;
                g = invG = (Graphics2D)g.create();
                ((Graphics2D)invG).setTransform(tx);
            }
        }
        try {
            if (op != null && image instanceof BufferedImage) {
                image = op.filter((BufferedImage)image, null);
            }
            if (invG != null && hasDstSize) {
                dw = (int)Math.round((double)dw * scaleX);
                dh = (int)Math.round((double)dh * scaleY);
            }
            if (srcBounds != null) {
                int sh;
                int sx = (int)Math.round((double)srcBounds.x * scaleX);
                int sy = (int)Math.round((double)srcBounds.y * scaleY);
                int sw = srcBounds.width >= 0 ? (int)Math.round((double)srcBounds.width * scaleX) : (int)Math.round((double)userWidth * scaleX) - sx;
                int n = sh = srcBounds.height >= 0 ? (int)Math.round((double)srcBounds.height * scaleY) : (int)Math.round((double)userHeight * scaleY) - sy;
                if (!hasDstSize) {
                    dw = (int)Math.round((double)userWidth * scaleX);
                    dh = (int)Math.round((double)userHeight * scaleY);
                }
                g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, observer);
            } else if (hasDstSize) {
                g.drawImage(image, dx, dy, dw, dh, observer);
            } else if (invG == null) {
                g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            } else {
                g.drawImage(image, dx, dy, observer);
            }
        }
        finally {
            if (invG != null) {
                invG.dispose();
            }
        }
    }
}

