/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.HLineGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ABLineGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nABLineGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ABLineGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ABLineGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1855#2,2:77\n*S KotlinDebug\n*F\n+ 1 ABLineGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ABLineGeom\n*L\n69#1:77,2\n*E\n"})
public final class ABLineGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return HLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper.SvgElementHelper helper2 = new GeomHelper(pos, coord, ctx).createSvgElementHelper();
        helper2.setStrokeAlphaEnabled(true);
        DoubleRectangle viewPort = GeomBase.Companion.overallAesBounds(ctx);
        List boundaries = CollectionsKt.toList((Iterable)viewPort.getParts());
        ArrayList<SvgLineElement> lines = new ArrayList<SvgLineElement>();
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            Iterator it;
            Double slope;
            Double intercept = p.intercept();
            if (!SeriesUtil.INSTANCE.allFinite(intercept, slope = p.slope())) continue;
            double d = viewPort.getLeft();
            Double d2 = intercept;
            Intrinsics.checkNotNull((Object)d2);
            double d3 = d2;
            double d4 = viewPort.getLeft();
            Double d5 = slope;
            Intrinsics.checkNotNull((Object)d5);
            DoubleVector p1 = new DoubleVector(d, d3 + d4 * d5);
            DoubleVector p2 = new DoubleVector(viewPort.getRight(), p1.getY() + viewPort.getDimension().getX() * slope);
            DoubleSegment s = new DoubleSegment(p1, p2);
            HashSet<DoubleVector> lineEnds = new HashSet<DoubleVector>(2);
            for (DoubleSegment boundary : boundaries) {
                DoubleVector intersection = boundary.intersection(s);
                if (intersection == null) continue;
                lineEnds.add(intersection);
                if (lineEnds.size() != 2) continue;
            }
            if (lineEnds.size() != 2) continue;
            Intrinsics.checkNotNullExpressionValue(lineEnds.iterator(), (String)"iterator(...)");
            Object e = it.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            DoubleVector doubleVector = (DoubleVector)e;
            Object e2 = it.next();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
            SvgLineElement line = GeomHelper.SvgElementHelper.createLine$default(helper2, doubleVector, (DoubleVector)e2, p, null, 8, null);
            if (line == null) continue;
            lines.add(line);
        }
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgLineElement it = (SvgLineElement)element$iv;
            boolean bl = false;
            root.add((SvgNode)it);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ABLineGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

