/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.net.URI;
import java.util.regex.Pattern;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;

public final class HttpWebdav
extends HttpEntityEnclosingRequestBase {
    private static final Pattern WEBDAV_METHOD_PATTERN = Pattern.compile("(?i)[\\da-z!#$%&'*+\\-.^_`|~]+");
    private final String davMethod;

    public HttpWebdav(String davMethod, URI uri) {
        this.davMethod = davMethod;
        this.setURI(uri);
    }

    public String getMethod() {
        return this.davMethod;
    }

    public static boolean isWebdavMethod(String method) {
        return method != null && WEBDAV_METHOD_PATTERN.matcher(method).matches();
    }
}

