/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.FileWrapper;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Function.class})
public class CSVRead
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(CSVRead.class);
    private static final String KEY = "__CSVRead";
    private static final List<String> desc = new ArrayList<String>();
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String myValue = "";
        String fileName = ((CompoundVariable)this.values[0]).execute();
        String columnOrNext = ((CompoundVariable)this.values[1]).execute();
        log.debug("execute ({}, {})   ", (Object)fileName, (Object)columnOrNext);
        if (columnOrNext.startsWith("*")) {
            FileWrapper.open(fileName, columnOrNext);
            return "";
        }
        if (columnOrNext.equals("next()") || columnOrNext.equals("next")) {
            FileWrapper.endRow(fileName);
            return "";
        }
        try {
            int columnIndex = Integer.parseInt(columnOrNext);
            myValue = FileWrapper.getColumn(fileName, columnIndex);
        }
        catch (NumberFormatException e) {
            log.warn("{} - can't parse column number: {} {}", new Object[]{Thread.currentThread().getName(), columnOrNext, e.toString()});
        }
        catch (IndexOutOfBoundsException e) {
            log.warn("{} - invalid column number: {} at row {} {}", new Object[]{Thread.currentThread().getName(), columnOrNext, FileWrapper.getCurrentRow(fileName), e.toString()});
        }
        log.debug("execute value: {}", (Object)myValue);
        return myValue;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public String getReferenceKey() {
        return KEY;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        if (log.isDebugEnabled()) {
            log.debug("setParameter - Collection.size={}", (Object)parameters.size());
        }
        this.values = parameters.toArray();
        if (log.isDebugEnabled()) {
            for (int i = 0; i < parameters.size(); ++i) {
                log.debug("i: {}", (Object)((CompoundVariable)this.values[i]).execute());
            }
        }
        this.checkParameterCount(parameters, 2);
        FileWrapper.clearAll();
    }

    static {
        desc.add(JMeterUtils.getResString((String)"csvread_file_file_name"));
        desc.add(JMeterUtils.getResString((String)"column_number"));
    }
}

