/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.MenuElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractActionWithNoRunningTest;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Command.class, MenuCreator.class})
public class Restart
extends AbstractActionWithNoRunningTest
implements MenuCreator {
    private static final Logger log = LoggerFactory.getLogger(Restart.class);
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doActionAfterCheck(ActionEvent e) {
        try {
            GuiPackage guiPackage = GuiPackage.getInstance();
            ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "check_dirty"));
            if (guiPackage.isDirty()) {
                int chosenOption = JOptionPane.showConfirmDialog(guiPackage.getMainFrame(), JMeterUtils.getResString("cancel_exit_to_save"), JMeterUtils.getResString("save?"), 1, 3);
                if (chosenOption == 1) {
                    Restart.restartApplication(null);
                } else if (chosenOption == 0) {
                    ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "save"));
                    if (!guiPackage.isDirty()) {
                        Restart.restartApplication(null);
                    }
                }
            } else {
                Restart.restartApplication(null);
            }
        }
        catch (Exception ex) {
            log.error("Error trying to restart: {}", (Object)ex.getMessage(), (Object)ex);
            JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("restart_error") + ":\n" + ex.getLocalizedMessage(), JMeterUtils.getResString("error_title"), 0);
        }
    }

    public static void restartApplication(Runnable runBeforeRestart) {
        String javaCommand = System.getProperty(SUN_JAVA_COMMAND);
        final ArrayList<String> processArgs = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)javaCommand)) {
            JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("restart_error") + ":\n This command is only supported on Open JDK or Oracle JDK", JMeterUtils.getResString("error_title"), 0);
            return;
        }
        processArgs.add(System.getProperty("java.home") + "/bin/java");
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : vmArguments) {
            if (arg.contains("-agentlib")) continue;
            processArgs.add(arg);
        }
        String[] mainCommand = javaCommand.split(" ");
        if (mainCommand[0].endsWith(".jar")) {
            processArgs.add("-jar");
            processArgs.add(new File(mainCommand[0]).getPath());
        } else {
            processArgs.add("-cp");
            processArgs.add(System.getProperty("java.class.path"));
            processArgs.add(mainCommand[0]);
        }
        Restart.processRemainingArgs(processArgs, mainCommand);
        log.debug("Restart with {} from [{}]", processArgs, (Object)javaCommand);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    new ProcessBuilder(processArgs).start();
                }
                catch (IOException e) {
                    log.error("Error calling restart command {}", (Object)processArgs, (Object)e);
                }
            }
        });
        if (runBeforeRestart != null) {
            runBeforeRestart.run();
        }
        System.exit(0);
    }

    private static void processRemainingArgs(List<? super String> processArgs, String[] mainCommand) {
        boolean paramValue = false;
        StringBuilder partialParamValue = new StringBuilder();
        for (int i = 1; i < mainCommand.length; ++i) {
            String currentPart = mainCommand[i];
            if (paramValue) {
                if (currentPart.startsWith("-")) {
                    paramValue = false;
                    processArgs.add(partialParamValue.toString());
                    partialParamValue.setLength(0);
                    processArgs.add(currentPart);
                    continue;
                }
                partialParamValue.append(" ");
                partialParamValue.append(currentPart);
                continue;
            }
            if (currentPart.startsWith("-")) {
                processArgs.add(currentPart);
                continue;
            }
            paramValue = true;
            partialParamValue.setLength(0);
            partialParamValue.append(currentPart);
        }
        if (paramValue) {
            processArgs.add(partialParamValue.toString());
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public JMenuItem[] getMenuItemsAtLocation(MenuCreator.MENU_LOCATION location) {
        if (location == MenuCreator.MENU_LOCATION.FILE) {
            JMenuItem menuItemIC = new JMenuItem(JMeterUtils.getResString("restart"), 0);
            menuItemIC.setName("restart");
            menuItemIC.setActionCommand("restart");
            menuItemIC.setAccelerator(null);
            menuItemIC.addActionListener(ActionRouter.getInstance());
            return new JMenuItem[]{menuItemIC};
        }
        return new JMenuItem[0];
    }

    @Override
    public JMenu[] getTopLevelMenus() {
        return new JMenu[0];
    }

    @Override
    public boolean localeChanged(MenuElement menu) {
        return false;
    }

    @Override
    public void localeChanged() {
    }

    static {
        commands.add("restart");
    }
}

