/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.IntegerList;
import org.apache.sis.parameter.UnmodifiableParameterValue;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.gml.Measure;
import org.apache.sis.xml.bind.gml.MeasureList;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

@XmlType(name="ParameterValueType", propOrder={"xmlValue", "descriptor"})
@XmlRootElement(name="ParameterValue")
public class DefaultParameterValue<T>
extends FormattableObject
implements ParameterValue<T>,
LenientComparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5837826787089486776L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.parameter");
    private ParameterDescriptor<T> descriptor;
    protected T value;
    protected Unit<?> unit;

    public DefaultParameterValue(ParameterDescriptor<T> descriptor) {
        ArgumentChecks.ensureNonNull("descriptor", descriptor);
        this.descriptor = descriptor;
        this.value = descriptor.getDefaultValue();
        this.unit = descriptor.getUnit();
    }

    public DefaultParameterValue(ParameterValue<T> parameter) {
        ArgumentChecks.ensureNonNull("parameter", parameter);
        this.descriptor = parameter.getDescriptor();
        this.value = parameter.getValue();
        this.unit = parameter.getUnit();
    }

    @Override
    @XmlElement(name="operationParameter", required=true)
    public ParameterDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public int intValue() throws IllegalStateException {
        int integer;
        T value = this.getValue();
        if (value instanceof Number && (double)(integer = ((Number)value).intValue()) == ((Number)value).doubleValue()) {
            return integer;
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public int[] intValueList() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof int[]) {
            return (int[])((int[])value).clone();
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public double doubleValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public double[] doubleValueList() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof double[]) {
            return (double[])((double[])value).clone();
        }
        throw this.missingOrIncompatibleValue(value);
    }

    private UnitConverter getConverterTo(Unit<?> unit) {
        Unit<?> source = this.getUnit();
        if (source == null) {
            throw new IllegalStateException(Resources.format((short)65, Verifier.getDisplayName(this.descriptor)));
        }
        ArgumentChecks.ensureNonNull("unit", unit);
        short expectedID = Verifier.getUnitMessageID(source);
        if (Verifier.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        try {
            return source.getConverterToAny(unit);
        }
        catch (IncommensurableException e2) {
            throw new IllegalArgumentException(Errors.format((short)66, source, unit), e2);
        }
    }

    @Override
    public double doubleValue(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        double value = this.doubleValue();
        return this.getConverterTo(unit).convert(value);
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        UnitConverter converter = this.getConverterTo(unit);
        double[] values = this.doubleValueList();
        for (int i = 0; i < values.length; ++i) {
            values[i] = converter.convert(values[i]);
        }
        return values;
    }

    @Override
    public String stringValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof CharSequence) {
            return value.toString();
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public URI valueFile() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof URI) {
            return (URI)value;
        }
        if (value instanceof File) {
            return ((File)value).toURI();
        }
        if (value instanceof Path) {
            return ((Path)value).toUri();
        }
        URISyntaxException cause = null;
        if (value instanceof URL) {
            try {
                return ((URL)value).toURI();
            }
            catch (URISyntaxException exception) {
                cause = exception;
            }
        }
        String name = Verifier.getDisplayName(this.descriptor);
        if (value != null) {
            throw new InvalidParameterTypeException(this.getClassTypeError(), name);
        }
        throw new IllegalStateException(Resources.format((short)44, name), cause);
    }

    private static boolean isFile(Object value) {
        return value instanceof URI || value instanceof URL || value instanceof File || value instanceof Path;
    }

    private boolean isOrNeedFile(Object newValue) {
        if (newValue instanceof String) {
            Class<T> type = this.descriptor.getValueClass();
            return type == URI.class || type == URL.class || Path.class.isAssignableFrom(type) || File.class.isAssignableFrom(type);
        }
        return DefaultParameterValue.isFile(newValue);
    }

    private IllegalStateException missingOrIncompatibleValue(Object newValue) {
        String name = Verifier.getDisplayName(this.descriptor);
        if (newValue != null) {
            return new InvalidParameterTypeException(this.getClassTypeError(), name);
        }
        return new IllegalStateException(Resources.format((short)44, name));
    }

    private String getClassTypeError() {
        return Resources.format((short)22, this.descriptor != null ? this.descriptor.getValueClass() : "?");
    }

    private static Number cast(Number value, Class<?> expectedClass) {
        Object n;
        if (expectedClass == Double.class && value instanceof Float) {
            return DecimalFunctions.floatToDouble(value.floatValue());
        }
        if (Number.class.isAssignableFrom(expectedClass) && Numerics.equals(((Number)(n = Numbers.cast(value, expectedClass))).doubleValue(), value.doubleValue())) {
            return n;
        }
        return value;
    }

    @Override
    public void setValue(Object newValue) throws InvalidParameterValueException {
        block13: {
            Class<T> expectedClass;
            if (newValue != null && !(expectedClass = this.descriptor.getValueClass()).isInstance(newValue)) {
                if (newValue instanceof Number) {
                    newValue = DefaultParameterValue.cast((Number)newValue, expectedClass);
                } else if (this.isOrNeedFile(newValue)) {
                    try {
                        newValue = ObjectConverters.convert(newValue, expectedClass);
                    }
                    catch (UnconvertibleObjectException e2) {
                        Logging.recoverableException(LOGGER, DefaultParameterValue.class, "setValue", e2);
                    }
                } else {
                    Class<?> componentType = expectedClass.getComponentType();
                    if (componentType != null) {
                        Object[] objectArray;
                        if (newValue.getClass().isArray()) {
                            objectArray = newValue;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = newValue;
                        }
                        Object[] array = objectArray;
                        int length = Array.getLength(array);
                        if (length > 0) {
                            Object copy = Array.newInstance(componentType, length);
                            componentType = Numbers.primitiveToWrapper(componentType);
                            for (int i = 0; i < length; ++i) {
                                Object element = Array.get(array, i);
                                if (element == null) continue;
                                if (element instanceof Number && componentType.isInstance(element = DefaultParameterValue.cast((Number)element, componentType))) {
                                    Array.set(copy, i, element);
                                    continue;
                                }
                                break block13;
                            }
                            newValue = copy;
                        }
                    }
                }
            }
        }
        this.setValue(newValue, this.unit);
    }

    @Override
    public void setValue(boolean newValue) throws InvalidParameterValueException {
        this.setValue(newValue, this.unit);
    }

    @Override
    public void setValue(int newValue) throws InvalidParameterValueException {
        Number n = newValue;
        Number c = DefaultParameterValue.cast(n, this.descriptor.getValueClass());
        if (c.intValue() == newValue) {
            n = c;
        }
        this.setValue(n, this.unit);
    }

    private static Number wrap(double value, Class<?> valueClass) throws IllegalArgumentException {
        if (Number.class.isAssignableFrom(valueClass)) {
            return Numbers.wrap(value, valueClass);
        }
        return value;
    }

    @Override
    public void setValue(double newValue) throws InvalidParameterValueException {
        Number n;
        try {
            n = DefaultParameterValue.wrap(newValue, this.descriptor.getValueClass());
        }
        catch (IllegalArgumentException e2) {
            throw (InvalidParameterValueException)new InvalidParameterValueException(e2.getLocalizedMessage(), Verifier.getDisplayName(this.descriptor), newValue).initCause(e2);
        }
        this.setValue(n, this.unit);
    }

    @Override
    public void setValue(double newValue, Unit<?> unit) throws InvalidParameterValueException {
        Number n;
        try {
            n = DefaultParameterValue.wrap(newValue, this.descriptor.getValueClass());
        }
        catch (IllegalArgumentException e2) {
            throw (InvalidParameterValueException)new InvalidParameterValueException(e2.getLocalizedMessage(), Verifier.getDisplayName(this.descriptor), newValue).initCause(e2);
        }
        this.setValue(n, unit);
    }

    @Override
    public void setValue(double[] newValues, Unit<?> unit) throws InvalidParameterValueException {
        this.setValue((Object)newValues, unit);
    }

    protected void setValue(Object newValue, Unit<?> unit) throws InvalidParameterValueException {
        T convertedValue = Verifier.ensureValidValue(this.descriptor, newValue, unit);
        if (newValue != null) {
            this.validate(convertedValue);
            this.value = newValue;
        } else {
            this.value = this.descriptor.getDefaultValue();
        }
        this.unit = unit;
    }

    protected void validate(T newValue) throws InvalidParameterValueException {
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (mode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    DefaultParameterValue that = (DefaultParameterValue)object;
                    return Objects.equals(this.descriptor, that.descriptor) && Objects.deepEquals(this.value, that.value) && Objects.equals(this.unit, that.unit);
                }
            } else if (object instanceof ParameterValue) {
                ParameterValue that = (ParameterValue)object;
                return Utilities.deepEquals(this.getDescriptor(), that.getDescriptor(), mode) && Utilities.deepEquals(this.getValue(), that.getValue(), mode) && Utilities.deepEquals(this.getUnit(), that.getUnit(), mode);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        int code = 37 * this.descriptor.hashCode();
        if (this.value != null) {
            code += this.value.hashCode();
        }
        if (this.unit != null) {
            code += 31 * this.unit.hashCode();
        }
        return code;
    }

    @Override
    public DefaultParameterValue<T> clone() {
        try {
            return (DefaultParameterValue)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static <T> DefaultParameterValue<T> unmodifiable(ParameterValue<T> parameter) {
        return UnmodifiableParameterValue.create(parameter);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        GeneralParameterDescriptor descriptor = this.getDescriptor();
        WKTUtilities.appendName(descriptor, formatter, ElementKind.PARAMETER);
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        Unit<?> unit = this.getUnit();
        if (unit == null) {
            T value = this.getValue();
            if (!isWKT1 && DefaultParameterValue.isFile(value)) {
                formatter.append(value.toString(), null);
                return "ParameterFile";
            }
            formatter.appendAny(value);
        } else {
            double value;
            boolean ignoreUnits;
            Unit<?> contextualUnit;
            if (descriptor == null || (contextualUnit = descriptor.getUnit()) == null) {
                contextualUnit = unit;
            }
            contextualUnit = formatter.toContextualUnit(contextualUnit);
            if (isWKT1) {
                unit = contextualUnit;
                ignoreUnits = true;
            } else {
                if (convention != Convention.INTERNAL) {
                    unit = WKTUtilities.toFormattable(unit);
                }
                ignoreUnits = unit.equals(contextualUnit);
            }
            try {
                value = this.doubleValue(unit);
            }
            catch (IllegalStateException exception) {
                if (descriptor != null) {
                    formatter.setInvalidWKT(descriptor, (Exception)exception);
                } else {
                    formatter.setInvalidWKT(DefaultParameterValue.class, (Exception)exception);
                }
                value = Double.NaN;
            }
            formatter.append(value);
            if (!ignoreUnits && !Double.isNaN(value)) {
                ignoreUnits = Numerics.equals(value, this.doubleValue(contextualUnit));
            }
            if (ignoreUnits && convention != Convention.INTERNAL) {
                boolean bl = ignoreUnits = convention.isSimplified() && DefaultParameterValue.hasContextualUnit(formatter);
            }
            if (!ignoreUnits) {
                if (!isWKT1) {
                    formatter.append(unit);
                } else if (!ignoreUnits) {
                    if (descriptor != null) {
                        formatter.setInvalidWKT(descriptor, null);
                    } else {
                        formatter.setInvalidWKT(DefaultParameterValue.class, null);
                    }
                }
            }
        }
        return "Parameter";
    }

    private static boolean hasContextualUnit(Formatter formatter) {
        return formatter.hasContextualUnit(1) || formatter.hasContextualUnit(2);
    }

    private DefaultParameterValue() {
    }

    final void setDescriptor(ParameterDescriptor<T> descriptor) {
        this.descriptor = descriptor;
        if (descriptor instanceof DefaultParameterDescriptor) {
            ((DefaultParameterDescriptor)descriptor).setValueClass(this);
        }
    }

    @XmlElements(value={@XmlElement(name="value", type=Measure.class), @XmlElement(name="integerValue", type=Integer.class), @XmlElement(name="booleanValue", type=Boolean.class), @XmlElement(name="stringValue", type=String.class), @XmlElement(name="valueFile", type=URI.class), @XmlElement(name="integerValueList", type=IntegerList.class), @XmlElement(name="valueList", type=MeasureList.class)})
    private Object getXmlValue() {
        T value = this.getValue();
        if (value != null) {
            if (value instanceof Number) {
                int xmlValue;
                Number n = (Number)value;
                if (Numbers.isInteger(n.getClass()) && (xmlValue = n.intValue()) >= 0 && (double)xmlValue == n.doubleValue()) {
                    return xmlValue;
                }
                return new Measure(((Number)value).doubleValue(), this.getUnit());
            }
            if (value instanceof CharSequence) {
                return value.toString();
            }
            if (DefaultParameterValue.isFile(value)) {
                return ObjectConverters.convert(value, URI.class);
            }
            Class<?> type = Numbers.primitiveToWrapper(value.getClass().getComponentType());
            if (type != null && Number.class.isAssignableFrom(type)) {
                if (Numbers.isInteger(type)) {
                    return new IntegerList(value);
                }
                return new MeasureList(value, type, this.getUnit());
            }
        }
        return value;
    }

    private void setXmlValue(Object xmlValue) {
        if (this.value == null && this.unit == null) {
            if (xmlValue instanceof Measure) {
                Measure measure = (Measure)xmlValue;
                xmlValue = measure.value;
                this.unit = measure.unit;
            } else if (xmlValue instanceof MeasureList) {
                MeasureList measure = (MeasureList)xmlValue;
                xmlValue = measure.toArray();
                this.unit = measure.unit;
            } else if (xmlValue instanceof IntegerList) {
                xmlValue = ((IntegerList)xmlValue).toArray();
            }
            this.value = this.descriptor != null ? ObjectConverters.convert(xmlValue, this.descriptor.getValueClass()) : xmlValue;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultParameterValue.class, "setXmlValue", "value");
        }
    }
}

