/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.Objects;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;

public class TxnOp {
    public static void txnTypeCompatibleEx(TxnType innerTxnType, TxnType outerTxnType) {
        boolean b = TxnOp.isTxnTypeCompatible(innerTxnType, outerTxnType);
        if (!b) {
            throw new JenaTransactionException("Already in a transaction of an incompatable type: outer=" + String.valueOf((Object)outerTxnType) + " : inner=" + String.valueOf((Object)innerTxnType));
        }
    }

    public static boolean isTxnTypeCompatible(TxnType innerTxnType, TxnType outerTxnType) {
        if (outerTxnType == null) {
            return true;
        }
        if (Objects.equals((Object)innerTxnType, (Object)outerTxnType)) {
            return true;
        }
        if (TxnType.READ.equals((Object)innerTxnType)) {
            return true;
        }
        if (TxnType.WRITE.equals((Object)outerTxnType)) {
            return true;
        }
        if (TxnType.READ.equals((Object)outerTxnType)) {
            return false;
        }
        return false;
    }

    public static void compatibleWithPromote(TxnType requestedTxnType, Transactional currentTxn) {
        TxnType currentTxnType = currentTxn.transactionType();
        if (currentTxnType == null) {
            return;
        }
        if (TxnType.READ.equals((Object)requestedTxnType)) {
            return;
        }
        if (TxnType.WRITE.equals((Object)currentTxnType)) {
            return;
        }
        if (TxnType.READ.equals((Object)currentTxnType)) {
            throw new JenaTransactionException("Already in a READ transaction: outer=" + String.valueOf((Object)currentTxnType) + " : inner=" + String.valueOf((Object)requestedTxnType));
        }
        if (requestedTxnType == TxnType.WRITE) {
            boolean x = currentTxn.promote();
            if (x) {
                return;
            }
            throw new JenaTransactionException("Can't promote outer transaction: outer=" + String.valueOf((Object)currentTxnType) + " : inner=" + String.valueOf((Object)requestedTxnType));
        }
        if (Objects.equals((Object)requestedTxnType, (Object)currentTxnType)) {
            return;
        }
        throw new JenaTransactionException("Already in a transaction of an incompatable type: outer=" + String.valueOf((Object)currentTxnType) + " : inner=" + String.valueOf((Object)requestedTxnType));
    }
}

