/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphUnionRead;
import org.apache.jena.sparql.graph.GraphWrapper;

public class GraphOps {
    public static boolean containsGraph(DatasetGraph dsg, Node gn) {
        if (Quad.isDefaultGraph(gn) || Quad.isUnionGraph(gn)) {
            return true;
        }
        return dsg.containsGraph(gn);
    }

    public static Graph getGraph(DatasetGraph dsg, Node gn) {
        if (gn == null) {
            return dsg.getDefaultGraph();
        }
        if (Quad.isDefaultGraph(gn)) {
            return dsg.getDefaultGraph();
        }
        if (Quad.isUnionGraph(gn)) {
            return GraphOps.unionGraph(dsg);
        }
        return dsg.getGraph(gn);
    }

    public static Graph unionGraph(DatasetGraph dsg, Set<Node> graphNames) {
        return new GraphUnionRead(dsg, graphNames);
    }

    public static Graph unionGraph(DatasetGraph dsg) {
        return new GraphUnionRead(dsg);
    }

    public static void addAll(Graph g, Iterator<Triple> iter) {
        while (iter.hasNext()) {
            g.add(iter.next());
        }
        Iter.close(iter);
    }

    public static void addAll(Graph g, Iterable<Triple> iter) {
        GraphOps.addAll(g, iter.iterator());
    }

    public static void deleteAll(Graph g, Iterator<Triple> iter) {
        while (iter.hasNext()) {
            g.delete(iter.next());
        }
        Iter.close(iter);
    }

    public static void deleteAll(Graph g, Iterable<Triple> iter) {
        GraphOps.deleteAll(g, iter.iterator());
    }

    public static Graph unwrapAll(Graph graph) {
        Graph graph1 = graph;
        Graph graph2;
        while ((graph2 = GraphOps.unwrapOne(graph1)) != graph1) {
            graph1 = graph2;
        }
        return graph1;
    }

    public static boolean isWrapped(Graph graph) {
        if (graph instanceof WrappedGraph) {
            return true;
        }
        return graph instanceof GraphWrapper;
    }

    public static Graph unwrapOne(Graph graph) {
        if (graph instanceof WrappedGraph) {
            return ((WrappedGraph)graph).getWrapped();
        }
        if (graph instanceof GraphWrapper) {
            return ((GraphWrapper)graph).get();
        }
        return graph;
    }
}

