/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.util.Collection;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.WriterConst;

class Widths {
    Widths() {
    }

    static int calcWidth(PrefixMap prefixMap, String baseURI, Node p, boolean printTypeKeyword) {
        String x = prefixMap.abbreviate(p.getURI());
        if (x == null) {
            return p.getURI().length() + 2;
        }
        if (printTypeKeyword && WriterConst.RDF_type.equals(p)) {
            return 1;
        }
        return x.length();
    }

    static int calcWidth(PrefixMap prefixMap, String baseURI, Collection<Node> nodes, int minWidth, int maxWidth, boolean printTypeKeyword) {
        Node prev = null;
        int nodeMaxWidth = minWidth;
        for (Node n : nodes) {
            int len;
            if (prev != null && prev.equals(n) || (len = Widths.calcWidth(prefixMap, baseURI, n, printTypeKeyword)) > maxWidth) continue;
            if (nodeMaxWidth < len) {
                nodeMaxWidth = len;
            }
            prev = n;
        }
        return nodeMaxWidth;
    }

    static int calcWidthTriples(PrefixMap prefixMap, String baseURI, Collection<Triple> triples, int minWidth, int maxWidth, boolean printTypeKeyword) {
        Node prev = null;
        int nodeMaxWidth = minWidth;
        for (Triple triple : triples) {
            int len;
            Node n = triple.getPredicate();
            if (prev != null && prev.equals(n) || (len = Widths.calcWidth(prefixMap, baseURI, n, printTypeKeyword)) > maxWidth) continue;
            if (nodeMaxWidth < len) {
                nodeMaxWidth = len;
            }
            prev = n;
        }
        return nodeMaxWidth;
    }
}

