/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.access.DataAccessCtl;
import org.apache.jena.fuseki.access.DataAccessLib;
import org.apache.jena.fuseki.access.SecurityContext;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQLProtocol;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;

public final class AccessCtl_SPARQL_QueryDataset
extends SPARQL_QueryDataset {
    private final Function<HttpAction, String> requestUser;
    private static boolean ALLOW_FROM = true;

    public AccessCtl_SPARQL_QueryDataset(Function<HttpAction, String> requestUser) {
        this.requestUser = requestUser;
    }

    @Override
    protected Collection<String> customParams() {
        return Collections.singletonList("user");
    }

    @Override
    protected Pair<DatasetGraph, Query> decideDataset(HttpAction action, Query query2, String queryStringLog) {
        DatasetGraph dsg = action.getActiveDSG();
        if (!DataAccessCtl.isAccessControlled(dsg)) {
            return super.decideDataset(action, query2, queryStringLog);
        }
        DatasetDescription dsDesc0 = SPARQLProtocol.getDatasetDescription(action, query2);
        SecurityContext sCxt = DataAccessLib.getSecurityContext(action, dsg, this.requestUser);
        DatasetGraph dsg2 = this.dynamicDataset(action, query2, dsg, dsDesc0, sCxt);
        return Pair.create(dsg2, query2);
    }

    private DatasetGraph dynamicDataset(HttpAction action, Query query2, DatasetGraph dsg0, DatasetDescription dsDesc0, SecurityContext sCxt) {
        DatasetDescription dsDesc1;
        if (dsDesc0 == null) {
            return dsg0;
        }
        if (!ALLOW_FROM) {
            ServletOps.errorBadRequest("Use GRAPH. (FROM/FROM NAMED is not compatible with data access control.)");
        }
        if ((dsDesc1 = DatasetDescription.create(this.mask(dsDesc0.getDefaultGraphURIs(), sCxt), this.mask(dsDesc0.getNamedGraphURIs(), sCxt))).isEmpty()) {
            return DatasetGraphZero.create();
        }
        if (dsDesc1.getDefaultGraphURIs().contains(Quad.unionGraph.getURI())) {
            dsDesc1.getDefaultGraphURIs().remove(Quad.unionGraph.getURI());
            dsDesc1.getDefaultGraphURIs().addAll(sCxt.visibleGraphNames());
        }
        DatasetGraph dsg1 = DynamicDatasets.dynamicDataset(dsDesc1, dsg0, false);
        if (query2.hasDatasetDescription()) {
            query2.getGraphURIs().clear();
            query2.getNamedGraphURIs().clear();
        }
        return dsg1;
    }

    private List<String> mask(List<String> graphURIs, SecurityContext sCxt) {
        Collection<String> names = sCxt.visibleGraphNames();
        if (names == null) {
            return graphURIs;
        }
        return graphURIs.stream().filter(gn -> names.contains(gn) || sCxt.visableDefaultGraph() && Quad.defaultGraphIRI.getURI().equals(gn) || Quad.unionGraph.getURI().equals(gn)).collect(Collectors.toList());
    }

    @Override
    protected QueryExec createQueryExec(HttpAction action, Query query2, DatasetGraph target) {
        DatasetGraph dsg;
        if (!ALLOW_FROM && target instanceof DynamicDatasets.DynamicDatasetGraph) {
            ServletOps.errorBadRequest("FROM/FROM NAMED is not compatible with data access control.");
        }
        if ((dsg = action.getActiveDSG()) == null) {
            return super.createQueryExec(action, query2, target);
        }
        if (!DataAccessCtl.isAccessControlled(dsg)) {
            return super.createQueryExec(action, query2, target);
        }
        SecurityContext sCxt = DataAccessLib.getSecurityContext(action, dsg, this.requestUser);
        QueryExec qExec = sCxt.createQueryExec(query2, target);
        return qExec;
    }
}

