/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.context.cache.LruCache;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import java.net.URI;
import java.util.Objects;

public class LRUDocumentCache
implements DocumentLoader {
    private final DocumentLoader documentLoader;
    private final LruCache<Object, Document> cache;

    public LRUDocumentCache(DocumentLoader documentLoader, int cacheSize) {
        this.documentLoader = documentLoader;
        this.cache = new LruCache(cacheSize);
    }

    @Override
    public Document loadDocument(URI url, DocumentLoaderOptions options) throws JsonLdError {
        Object key = this.createCacheKey(url, options);
        Document result = this.cache.get(key);
        if (result == null) {
            result = this.documentLoader.loadDocument(url, options);
            this.cache.put(key, result);
        }
        return result;
    }

    protected Object createCacheKey(URI url, DocumentLoaderOptions options) {
        return new CacheKey(url, options);
    }

    protected static class CacheKey {
        private final URI url;
        private final DocumentLoaderOptions options;

        public CacheKey(URI url, DocumentLoaderOptions options) {
            this.url = url;
            this.options = options;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            return Objects.equals(this.url, cacheKey.url) && Objects.equals(this.options, cacheKey.options);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.options);
        }
    }
}

