/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.ontapi.model.AsNamed;
import org.apache.jena.ontapi.model.HasRDFNodeList;
import org.apache.jena.ontapi.model.HasValue;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntFacetRestriction;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.model.SetComponents;
import org.apache.jena.ontapi.model.SetValue;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;

public interface OntDataRange
extends OntObject,
AsNamed<Named> {
    @Override
    default public Named asNamed() {
        return (Named)this.as(Named.class);
    }

    default public int arity() {
        return 1;
    }

    public static interface Named
    extends OntEntity,
    OntDataRange {
        @Override
        default public Named asNamed() {
            return this;
        }

        default public Stream<OntDataRange> equivalentClasses() {
            return this.objects(OWL2.equivalentClass, OntDataRange.class);
        }

        default public OntStatement addEquivalentClassStatement(OntDataRange other) {
            return this.addStatement(OWL2.equivalentClass, (RDFNode)other);
        }

        default public Named addEquivalentClass(OntDataRange other) {
            this.addEquivalentClassStatement(other);
            return this;
        }

        default public Named removeEquivalentClass(Resource other) {
            this.remove(OWL2.equivalentClass, (RDFNode)other);
            return this;
        }

        default public RDFDatatype toRDFDatatype() {
            return TypeMapper.getInstance().getSafeTypeByName(this.getURI());
        }

        default public Literal createLiteral(Object obj) {
            return this.createLiteral(String.valueOf(Objects.requireNonNull(obj)));
        }

        default public Literal createLiteral(String lex) {
            return this.getModel().createTypedLiteral(Objects.requireNonNull(lex), this.toRDFDatatype());
        }

        @Override
        default public Named addComment(String txt) {
            return this.addComment(txt, null);
        }

        @Override
        default public Named addComment(String txt, String lang) {
            return this.annotate(this.getModel().getRDFSComment(), txt, lang);
        }

        @Override
        default public Named addLabel(String txt) {
            return this.addLabel(txt, null);
        }

        @Override
        default public Named addLabel(String txt, String lang) {
            return this.annotate(this.getModel().getRDFSLabel(), txt, lang);
        }

        @Override
        default public Named annotate(OntAnnotationProperty predicate, String txt, String lang) {
            return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
        }

        @Override
        default public Named annotate(OntAnnotationProperty predicate, RDFNode value) {
            this.addAnnotation(predicate, value);
            return this;
        }
    }

    public static interface Combination<N extends RDFNode>
    extends OntDataRange,
    HasRDFNodeList<N> {
    }

    public static interface Restriction
    extends Combination<OntFacetRestriction>,
    SetComponents<OntFacetRestriction, Restriction>,
    SetValue<Named, Restriction>,
    HasValue<Named> {
        @Override
        public Stream<OntStatement> spec();

        default public Restriction addFacet(Class<? extends OntFacetRestriction> type, Literal literal) {
            this.getList().add(this.getModel().createFacetRestriction(type, literal));
            return this;
        }
    }

    public static interface OneOf
    extends Combination<Literal>,
    SetComponents<Literal, OneOf> {
    }

    public static interface UnionOf
    extends Combination<OntDataRange>,
    SetComponents<OntDataRange, UnionOf> {
    }

    public static interface IntersectionOf
    extends Combination<OntDataRange>,
    SetComponents<OntDataRange, IntersectionOf> {
    }

    public static interface ComplementOf
    extends OntDataRange,
    SetValue<OntDataRange, ComplementOf>,
    HasValue<OntDataRange> {
    }
}

