/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.Objects;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpUnfold
extends Op1 {
    protected final Expr expr;
    protected final Var var1;
    protected final Var var2;

    public OpUnfold(Op subOp, Expr expr, Var var1, Var var2) {
        super(subOp);
        this.expr = expr;
        this.var1 = var1;
        this.var2 = var2;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public Var getVar1() {
        return this.var1;
    }

    public Var getVar2() {
        return this.var2;
    }

    @Override
    public String getName() {
        return "unfold";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        OpUnfold op = new OpUnfold(subOp, this.expr, this.var1, this.var2);
        return op;
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpUnfold)) {
            return false;
        }
        OpUnfold unfold = (OpUnfold)other;
        if (!Objects.equals((Object)this.var1, (Object)unfold.var1)) {
            return false;
        }
        if (!Objects.equals((Object)this.var2, (Object)unfold.var2)) {
            return false;
        }
        if (!Objects.equals(this.expr, unfold.expr)) {
            return false;
        }
        return this.getSubOp().equalTo(unfold.getSubOp(), labelMap);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public int hashCode() {
        if (this.var2 == null) {
            return this.getName().hashCode() ^ this.expr.hashCode() ^ this.var1.hashCode() ^ this.getSubOp().hashCode();
        }
        return this.getName().hashCode() ^ this.expr.hashCode() ^ this.var1.hashCode() ^ this.var2.hashCode() ^ this.getSubOp().hashCode();
    }
}

