/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.TripleConstraint;
import org.apache.jena.shex.expressions.TripleExprCardinality;
import org.apache.jena.shex.expressions.TripleExprEachOf;
import org.apache.jena.shex.expressions.TripleExprNone;
import org.apache.jena.shex.expressions.TripleExprOneOf;
import org.apache.jena.shex.expressions.TripleExprRef;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.expressions.TripleExpression;

public class TripleExprWalker
implements TripleExprVisitor {
    private final TripleExprVisitor beforeVisitor;
    private final TripleExprVisitor afterVisitor;
    private final ShapeExprVisitor shapeVisitor;

    public TripleExprWalker(TripleExprVisitor beforeVisitor, TripleExprVisitor afterVisitor, ShapeExprVisitor shapeVisitor) {
        this.beforeVisitor = beforeVisitor;
        this.afterVisitor = afterVisitor;
        this.shapeVisitor = shapeVisitor;
    }

    private void before(TripleExpression tripleExpr) {
        if (this.beforeVisitor != null) {
            tripleExpr.visit(this.beforeVisitor);
        }
    }

    private void after(TripleExpression tripleExpr) {
        if (this.afterVisitor != null) {
            tripleExpr.visit(this.afterVisitor);
        }
    }

    @Override
    public void visit(TripleExprEachOf object) {
        this.before(object);
        object.expressions().forEach(tripleExpr -> tripleExpr.visit(this));
        this.after(object);
    }

    @Override
    public void visit(TripleExprOneOf object) {
        this.before(object);
        object.expressions().forEach(tripleExpr -> tripleExpr.visit(this));
        this.after(object);
    }

    @Override
    public void visit(TripleExprCardinality object) {
        this.before(object);
        object.target().visit(this);
        this.after(object);
    }

    @Override
    public void visit(TripleExprNone object) {
        this.before(object);
        this.after(object);
    }

    @Override
    public void visit(TripleExprRef object) {
        this.before(object);
        this.after(object);
    }

    @Override
    public void visit(TripleConstraint object) {
        this.before(object);
        if (this.shapeVisitor != null) {
            object.getShapeExpression().visit(this.shapeVisitor);
        }
        this.after(object);
    }
}

