/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponentLifecycle;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRSW;

public class TransactionalComponentByLock
extends TransactionalComponentLifecycle<Object> {
    private Lock lock = new LockMRSW();

    private TransactionalComponentByLock(ComponentId componentId) {
        super(componentId);
    }

    @Override
    public void startRecovery() {
    }

    @Override
    public void recover(ByteBuffer ref) {
        Log.warn((Object)this, (String)"Called to recover a transaction (ignored)");
    }

    @Override
    public void finishRecovery() {
    }

    @Override
    public void cleanStart() {
    }

    @Override
    protected Object _begin(ReadWrite readWrite, TxnId thisTxnId) {
        if (this.isWriteTxn()) {
            this.startWriteTxn();
        } else {
            this.startReadTxn();
        }
        return this.createState();
    }

    private Object createState() {
        return new Object();
    }

    @Override
    protected Object _promote(TxnId txnId, Object state) {
        if (this.isReadTxn()) {
            this.finishReadTxn();
            this.startWriteTxn();
        }
        return this.createState();
    }

    protected void startReadTxn() {
        this.lock.enterCriticalSection(true);
    }

    protected void startWriteTxn() {
        this.lock.enterCriticalSection(false);
    }

    protected void finishReadTxn() {
        this.lock.leaveCriticalSection();
    }

    protected void finishWriteTxn() {
        this.lock.leaveCriticalSection();
    }

    @Override
    protected ByteBuffer _commitPrepare(TxnId txnId, Object obj) {
        return null;
    }

    @Override
    protected void _commit(TxnId txnId, Object obj) {
        this.clearup();
    }

    @Override
    protected void _commitEnd(TxnId txnId, Object obj) {
        this.clearup();
    }

    @Override
    protected void _abort(TxnId txnId, Object obj) {
        this.clearup();
    }

    @Override
    protected void _complete(TxnId txnId, Object obj) {
    }

    @Override
    protected void _shutdown() {
        this.lock = null;
    }

    private void clearup() {
        if (this.isWriteTxn()) {
            this.finishWriteTxn();
        } else {
            this.finishReadTxn();
        }
    }
}

