/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RefreshStats
implements PlainJsonSerializable {
    private final long externalTotal;
    private final long externalTotalTimeInMillis;
    private final long listeners;
    private final long total;
    @Nullable
    private final String totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<RefreshStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RefreshStats::setupRefreshStatsDeserializer);

    private RefreshStats(Builder builder) {
        this.externalTotal = ApiTypeHelper.requireNonNull(builder.externalTotal, this, "externalTotal");
        this.externalTotalTimeInMillis = ApiTypeHelper.requireNonNull(builder.externalTotalTimeInMillis, this, "externalTotalTimeInMillis");
        this.listeners = ApiTypeHelper.requireNonNull(builder.listeners, this, "listeners");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
    }

    public static RefreshStats of(Function<Builder, ObjectBuilder<RefreshStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long externalTotal() {
        return this.externalTotal;
    }

    public final long externalTotalTimeInMillis() {
        return this.externalTotalTimeInMillis;
    }

    public final long listeners() {
        return this.listeners;
    }

    public final long total() {
        return this.total;
    }

    @Nullable
    public final String totalTime() {
        return this.totalTime;
    }

    public final long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("external_total");
        generator.write(this.externalTotal);
        generator.writeKey("external_total_time_in_millis");
        generator.write(this.externalTotalTimeInMillis);
        generator.writeKey("listeners");
        generator.write(this.listeners);
        generator.writeKey("total");
        generator.write(this.total);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupRefreshStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::externalTotal, JsonpDeserializer.longDeserializer(), "external_total");
        op.add(Builder::externalTotalTimeInMillis, JsonpDeserializer.longDeserializer(), "external_total_time_in_millis");
        op.add(Builder::listeners, JsonpDeserializer.longDeserializer(), "listeners");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RefreshStats> {
        private Long externalTotal;
        private Long externalTotalTimeInMillis;
        private Long listeners;
        private Long total;
        @Nullable
        private String totalTime;
        private Long totalTimeInMillis;

        public final Builder externalTotal(long value) {
            this.externalTotal = value;
            return this;
        }

        public final Builder externalTotalTimeInMillis(long value) {
            this.externalTotalTimeInMillis = value;
            return this;
        }

        public final Builder listeners(long value) {
            this.listeners = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        public RefreshStats build() {
            this._checkSingleUse();
            return new RefreshStats(this);
        }
    }
}

