/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import jakarta.mail.Flags;
import java.util.Arrays;
import java.util.List;

public class FlagsBuilder {
    private final Flags internalFlags = new Flags();

    public static FlagsBuilder builder() {
        return new FlagsBuilder();
    }

    public FlagsBuilder add(Flags.Flag ... flags) {
        for (Flags.Flag flag : flags) {
            this.internalFlags.add(flag);
        }
        return this;
    }

    public FlagsBuilder add(String ... flags) {
        for (String userFlag : flags) {
            this.internalFlags.add(userFlag);
        }
        return this;
    }

    public FlagsBuilder add(List<Flags> flags) {
        for (Flags flag : flags) {
            this.internalFlags.add(flag);
        }
        return this;
    }

    public FlagsBuilder add(Flags ... flagsArray) {
        this.add(Arrays.asList(flagsArray));
        return this;
    }

    public FlagsBuilder isAnswered(boolean isAnswered) {
        if (isAnswered) {
            this.internalFlags.add(Flags.Flag.ANSWERED);
        }
        return this;
    }

    public FlagsBuilder isDraft(boolean isDraft) {
        if (isDraft) {
            this.internalFlags.add(Flags.Flag.DRAFT);
        }
        return this;
    }

    public FlagsBuilder isDeleted(boolean isDeleted) {
        if (isDeleted) {
            this.internalFlags.add(Flags.Flag.DELETED);
        }
        return this;
    }

    public FlagsBuilder isFlagged(boolean isFlagged) {
        if (isFlagged) {
            this.internalFlags.add(Flags.Flag.FLAGGED);
        }
        return this;
    }

    public FlagsBuilder isRecent(boolean isRecent) {
        if (isRecent) {
            this.internalFlags.add(Flags.Flag.RECENT);
        }
        return this;
    }

    public FlagsBuilder isSeen(boolean isSeen) {
        if (isSeen) {
            this.internalFlags.add(Flags.Flag.SEEN);
        }
        return this;
    }

    public Flags build() {
        return new Flags(this.internalFlags);
    }
}

