/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.internal.Serialization;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.util.Bytes;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.MessageLite;

@Immutable
public final class ProtoParametersSerialization
implements Serialization {
    private final Bytes objectIdentifier;
    private final KeyTemplate keyTemplate;

    private ProtoParametersSerialization(KeyTemplate keyTemplate) {
        this.keyTemplate = keyTemplate;
        this.objectIdentifier = Util.toBytesFromPrintableAscii(keyTemplate.getTypeUrl());
    }

    public static ProtoParametersSerialization create(String typeUrl, OutputPrefixType outputPrefixType, MessageLite value) {
        return ProtoParametersSerialization.create(KeyTemplate.newBuilder().setTypeUrl(typeUrl).setOutputPrefixType(outputPrefixType).setValue(value.toByteString()).build());
    }

    public static ProtoParametersSerialization create(KeyTemplate keyTemplate) {
        return new ProtoParametersSerialization(keyTemplate);
    }

    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @Override
    public Bytes getObjectIdentifier() {
        return this.objectIdentifier;
    }
}

