/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.StreamResponse;
import org.apache.james.protocols.pop3.POP3Response;

public class POP3StreamResponse
extends POP3Response
implements StreamResponse {
    private final InputStream stream;

    public POP3StreamResponse(String code, CharSequence description, InputStream stream) {
        super(code, description);
        this.stream = stream;
    }

    public InputStream getStream() {
        return new SequenceInputStream(this.stream, new ByteArrayInputStream(".\r\n".getBytes()));
    }

    public Response immutable() {
        throw new UnsupportedOperationException("POP3StreamResponse can only be used once, so its not supported to reuse it");
    }
}

