/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.netty.AbstractAsyncServer;
import org.apache.james.protocols.netty.AbstractChannelPipelineFactory;
import org.apache.james.protocols.netty.AbstractSSLAwareChannelPipelineFactory;
import org.apache.james.protocols.netty.BasicChannelInboundHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.Encryption;
import org.apache.james.protocols.netty.LineDelimiterBasedChannelHandlerFactory;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;

public class NettyServer
extends AbstractAsyncServer {
    protected final Encryption secure;
    protected final Protocol protocol;
    private final ChannelHandlerFactory frameHandlerFactory;
    private int maxCurConnections;
    private int maxCurConnectionsPerIP;
    private boolean proxyRequired;

    private NettyServer(Protocol protocol, Encryption secure, boolean proxyRequired, ChannelHandlerFactory frameHandlerFactory) {
        this.protocol = protocol;
        this.secure = secure;
        this.proxyRequired = proxyRequired;
        this.frameHandlerFactory = frameHandlerFactory;
    }

    public void setMaxConcurrentConnections(int maxCurConnections) {
        if (this.isBound()) {
            throw new IllegalStateException("Server running already");
        }
        this.maxCurConnections = maxCurConnections;
    }

    public void setMaxConcurrentConnectionsPerIP(int maxCurConnectionsPerIP) {
        if (this.isBound()) {
            throw new IllegalStateException("Server running already");
        }
        this.maxCurConnectionsPerIP = maxCurConnectionsPerIP;
    }

    protected ChannelInboundHandlerAdapter createCoreHandler() {
        return new BasicChannelInboundHandler(new ProtocolMDCContextFactory.Standard(), this.protocol, this.secure, this.proxyRequired);
    }

    @Override
    public synchronized void bind() throws Exception {
        super.bind();
    }

    private ChannelHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    protected AbstractChannelPipelineFactory createPipelineFactory() {
        return new AbstractSSLAwareChannelPipelineFactory(this.getTimeout(), this.maxCurConnections, this.maxCurConnectionsPerIP, this.proxyRequired, () -> this.secure, this.getFrameHandlerFactory(), (EventExecutorGroup)new DefaultEventLoopGroup(16)){

            @Override
            protected ChannelInboundHandlerAdapter createHandler() {
                return NettyServer.this.createCoreHandler();
            }
        };
    }

    public static class Factory {
        private Protocol protocol;
        private boolean proxyRequired;
        private Optional<Encryption> secure = Optional.empty();
        private Optional<ChannelHandlerFactory> frameHandlerFactory = Optional.empty();

        @Inject
        public Factory() {
        }

        public Factory protocol(Protocol protocol) {
            Preconditions.checkNotNull((Object)protocol, (Object)"'protocol' is mandatory");
            this.protocol = protocol;
            return this;
        }

        public Factory secure(Encryption secure) {
            this.secure = Optional.ofNullable(secure);
            return this;
        }

        public Factory proxyRequired(boolean proxyRequired) {
            this.proxyRequired = proxyRequired;
            return this;
        }

        public Factory frameHandlerFactory(ChannelHandlerFactory frameHandlerFactory) {
            this.frameHandlerFactory = Optional.ofNullable(frameHandlerFactory);
            return this;
        }

        public NettyServer build() {
            Preconditions.checkState((this.protocol != null ? 1 : 0) != 0, (Object)"'protocol' is mandatory");
            return new NettyServer(this.protocol, this.secure.orElse(null), this.proxyRequired, this.frameHandlerFactory.orElse(new LineDelimiterBasedChannelHandlerFactory(8192)));
        }
    }
}

