/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.jmap.draft.model.ContinuationToken;

public class ContinuationTokenResponse {
    private final String continuationToken;
    private final ImmutableList<AuthenticationMethod> methods;
    private final String prompt;

    public static Builder builder() {
        return new Builder();
    }

    private ContinuationTokenResponse(String continuationToken, ImmutableList<AuthenticationMethod> methods, String prompt) {
        this.continuationToken = continuationToken;
        this.methods = methods;
        this.prompt = prompt;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public List<AuthenticationMethod> getMethods() {
        return this.methods;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public static class Builder {
        private String continuationToken;
        private ImmutableList<AuthenticationMethod> methods;
        private String prompt;

        private Builder() {
        }

        public Builder continuationToken(ContinuationToken continuationToken) {
            this.continuationToken = continuationToken.serialize();
            return this;
        }

        public Builder methods(List<AuthenticationMethod> methods) {
            this.methods = ImmutableList.copyOf(methods);
            return this;
        }

        public Builder methods(AuthenticationMethod ... methods) {
            this.methods = ImmutableList.copyOf((Object[])methods);
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public ContinuationTokenResponse build() {
            return new ContinuationTokenResponse(this.continuationToken, this.methods, this.prompt);
        }
    }

    public static enum AuthenticationMethod {
        PASSWORD("password"),
        EXTERNAL("external"),
        PROMPT("prompt");

        private final String value;

        private AuthenticationMethod(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

