/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.ReadAliasName;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.apache.james.mailbox.opensearch.IndexAttachments;
import org.apache.james.mailbox.opensearch.IndexHeaders;
import org.apache.james.mailbox.opensearch.MailboxOpenSearchConstants;

public class OpenSearchMailboxConfiguration {
    private static final String OPENSEARCH_INDEX_NAME = "opensearch.index.name";
    private static final String OPENSEARCH_INDEX_MAILBOX_NAME = "opensearch.index.mailbox.name";
    private static final String OPENSEARCH_ALIAS_READ_NAME = "opensearch.alias.read.name";
    private static final String OPENSEARCH_ALIAS_WRITE_NAME = "opensearch.alias.write.name";
    private static final String OPENSEARCH_ALIAS_READ_MAILBOX_NAME = "opensearch.alias.read.mailbox.name";
    private static final String OPENSEARCH_ALIAS_WRITE_MAILBOX_NAME = "opensearch.alias.write.mailbox.name";
    private static final String OPENSEARCH_INDEX_ATTACHMENTS = "opensearch.indexAttachments";
    private static final String OPENSEARCH_INDEX_HEADERS = "opensearch.indexHeaders";
    private static final boolean DEFAULT_INDEX_ATTACHMENTS = true;
    private static final boolean DEFAULT_INDEX_HEADERS = true;
    public static final OpenSearchMailboxConfiguration DEFAULT_CONFIGURATION = OpenSearchMailboxConfiguration.builder().build();
    private final IndexName indexMailboxName;
    private final ReadAliasName readAliasMailboxName;
    private final WriteAliasName writeAliasMailboxName;
    private final IndexAttachments indexAttachment;
    private final IndexHeaders indexHeaders;

    public static Builder builder() {
        return new Builder();
    }

    public static OpenSearchMailboxConfiguration fromProperties(Configuration configuration) {
        return OpenSearchMailboxConfiguration.builder().indexMailboxName(OpenSearchMailboxConfiguration.computeMailboxIndexName(configuration)).readAliasMailboxName(OpenSearchMailboxConfiguration.computeMailboxReadAlias(configuration)).writeAliasMailboxName(OpenSearchMailboxConfiguration.computeMailboxWriteAlias(configuration)).indexAttachment(OpenSearchMailboxConfiguration.provideIndexAttachments(configuration)).indexHeaders(OpenSearchMailboxConfiguration.provideIndexHeaders(configuration)).build();
    }

    static Optional<IndexName> computeMailboxIndexName(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(OPENSEARCH_INDEX_MAILBOX_NAME)).map(IndexName::new).or(() -> Optional.ofNullable(configuration.getString(OPENSEARCH_INDEX_NAME)).map(IndexName::new));
    }

    static Optional<WriteAliasName> computeMailboxWriteAlias(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(OPENSEARCH_ALIAS_WRITE_MAILBOX_NAME)).map(WriteAliasName::new).or(() -> Optional.ofNullable(configuration.getString(OPENSEARCH_ALIAS_WRITE_NAME)).map(WriteAliasName::new));
    }

    static Optional<ReadAliasName> computeMailboxReadAlias(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(OPENSEARCH_ALIAS_READ_MAILBOX_NAME)).map(ReadAliasName::new).or(() -> Optional.ofNullable(configuration.getString(OPENSEARCH_ALIAS_READ_NAME)).map(ReadAliasName::new));
    }

    private static IndexAttachments provideIndexAttachments(Configuration configuration) {
        if (configuration.getBoolean(OPENSEARCH_INDEX_ATTACHMENTS, true)) {
            return IndexAttachments.YES;
        }
        return IndexAttachments.NO;
    }

    private static IndexHeaders provideIndexHeaders(Configuration configuration) {
        if (configuration.getBoolean(OPENSEARCH_INDEX_HEADERS, true)) {
            return IndexHeaders.YES;
        }
        return IndexHeaders.NO;
    }

    private OpenSearchMailboxConfiguration(IndexName indexMailboxName, ReadAliasName readAliasMailboxName, WriteAliasName writeAliasMailboxName, IndexAttachments indexAttachment, IndexHeaders indexHeaders) {
        this.indexMailboxName = indexMailboxName;
        this.readAliasMailboxName = readAliasMailboxName;
        this.writeAliasMailboxName = writeAliasMailboxName;
        this.indexAttachment = indexAttachment;
        this.indexHeaders = indexHeaders;
    }

    public IndexName getIndexMailboxName() {
        return this.indexMailboxName;
    }

    public ReadAliasName getReadAliasMailboxName() {
        return this.readAliasMailboxName;
    }

    public WriteAliasName getWriteAliasMailboxName() {
        return this.writeAliasMailboxName;
    }

    public IndexAttachments getIndexAttachment() {
        return this.indexAttachment;
    }

    public IndexHeaders getIndexHeaders() {
        return this.indexHeaders;
    }

    public final boolean equals(Object o) {
        if (o instanceof OpenSearchMailboxConfiguration) {
            OpenSearchMailboxConfiguration that = (OpenSearchMailboxConfiguration)o;
            return Objects.equals((Object)this.indexAttachment, (Object)that.indexAttachment) && Objects.equals((Object)this.indexHeaders, (Object)that.indexHeaders) && Objects.equals(this.indexMailboxName, that.indexMailboxName) && Objects.equals(this.readAliasMailboxName, that.readAliasMailboxName) && Objects.equals(this.writeAliasMailboxName, that.writeAliasMailboxName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.indexMailboxName, this.readAliasMailboxName, this.writeAliasMailboxName, this.indexAttachment, this.indexHeaders, this.writeAliasMailboxName});
    }

    public static class Builder {
        private Optional<IndexName> indexMailboxName = Optional.empty();
        private Optional<ReadAliasName> readAliasMailboxName = Optional.empty();
        private Optional<WriteAliasName> writeAliasMailboxName = Optional.empty();
        private Optional<IndexAttachments> indexAttachment = Optional.empty();
        private Optional<IndexHeaders> indexHeaders = Optional.empty();

        Builder() {
        }

        Builder indexMailboxName(Optional<IndexName> indexMailboxName) {
            this.indexMailboxName = indexMailboxName;
            return this;
        }

        Builder readAliasMailboxName(Optional<ReadAliasName> readAliasMailboxName) {
            this.readAliasMailboxName = readAliasMailboxName;
            return this;
        }

        Builder writeAliasMailboxName(Optional<WriteAliasName> writeAliasMailboxName) {
            this.writeAliasMailboxName = writeAliasMailboxName;
            return this;
        }

        Builder indexAttachment(IndexAttachments indexAttachment) {
            this.indexAttachment = Optional.of(indexAttachment);
            return this;
        }

        Builder indexHeaders(IndexHeaders indexHeaders) {
            this.indexHeaders = Optional.of(indexHeaders);
            return this;
        }

        public OpenSearchMailboxConfiguration build() {
            return new OpenSearchMailboxConfiguration(this.indexMailboxName.orElse(MailboxOpenSearchConstants.DEFAULT_MAILBOX_INDEX), this.readAliasMailboxName.orElse(MailboxOpenSearchConstants.DEFAULT_MAILBOX_READ_ALIAS), this.writeAliasMailboxName.orElse(MailboxOpenSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS), this.indexAttachment.orElse(IndexAttachments.YES), this.indexHeaders.orElse(IndexHeaders.YES));
        }
    }
}

