/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.api;

import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DelegationUsernameChangeTaskStep
implements UsernameChangeTaskStep {
    private final DelegationStore delegationStore;

    @Inject
    public DelegationUsernameChangeTaskStep(DelegationStore delegationStore) {
        this.delegationStore = delegationStore;
    }

    @Override
    public UsernameChangeTaskStep.StepName name() {
        return new UsernameChangeTaskStep.StepName("DelegationUsernameChangeTaskStep");
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public Publisher<Void> changeUsername(Username oldUsername, Username newUsername) {
        return this.migrateDelegatees(oldUsername, newUsername).then(this.migrateDelegators(oldUsername, newUsername));
    }

    private Mono<Void> migrateDelegators(Username oldUsername, Username newUsername) {
        return Flux.from(this.delegationStore.delegatedUsers(oldUsername)).concatMap(delegator -> Mono.from(this.delegationStore.addAuthorizedUser((Username)delegator, newUsername)).then(Mono.from(this.delegationStore.removeAuthorizedUser((Username)delegator, oldUsername)))).then();
    }

    private Flux<Void> migrateDelegatees(Username oldUsername, Username newUsername) {
        return Flux.from(this.delegationStore.authorizedUsers(oldUsername)).concatMap(delegatee -> Mono.from(this.delegationStore.addAuthorizedUser(newUsername, (Username)delegatee)).then(Mono.from(this.delegationStore.removeAuthorizedUser(oldUsername, (Username)delegatee))));
    }
}

