/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SuppressReferentialIntegrityUpdatesRequestControl
extends Control {
    @NotNull
    public static final String SUPPRESS_REFINT_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.30";
    private static final long serialVersionUID = 4761880447993567116L;

    public SuppressReferentialIntegrityUpdatesRequestControl() {
        this(true);
    }

    public SuppressReferentialIntegrityUpdatesRequestControl(boolean isCritical) {
        super(SUPPRESS_REFINT_REQUEST_OID, isCritical, null);
    }

    public SuppressReferentialIntegrityUpdatesRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_REFINT_REQUEST_CONTROL_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SUPPRESS_REFINT_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", SUPPRESS_REFINT_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_SUPPRESS_REFINT_REQUEST.get()), new JSONField("criticality", this.isCritical()));
    }

    @NotNull
    public static SuppressReferentialIntegrityUpdatesRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, false, false);
        return new SuppressReferentialIntegrityUpdatesRequestControl(jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SuppressReferentialIntegrityUpdatesRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

