/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class UnitParser {
    private static final String PATTERN_STRING = "\\s*(-?[0-9]+)\\s*([a-z,A-Z]*)\\s*";
    private static final int AMOUNT = 1;
    private static final int UNIT = 2;
    private static Pattern PATTERN = Pattern.compile("\\s*(-?[0-9]+)\\s*([a-z,A-Z]*)\\s*");

    UnitParser() {
    }

    static ParsingResult parse(String rawString) throws NumberFormatException {
        Matcher res = PATTERN.matcher(rawString);
        if (res.matches()) {
            String unitAsString = res.group(2);
            String amountAsString = res.group(1);
            long amount = Integer.parseInt(amountAsString.trim());
            return new ParsingResult(amount, Optional.of(unitAsString).filter(Predicate.not(Strings::isNullOrEmpty)));
        }
        throw new NumberFormatException("Supplied value do not follow the unit format (number optionally suffixed with a string representing the unit");
    }

    static class ParsingResult {
        private final long number;
        private final Optional<String> unit;

        ParsingResult(long number, Optional<String> unit) {
            this.number = number;
            this.unit = unit;
        }

        public long getNumber() {
            return this.number;
        }

        public Optional<String> getUnit() {
            return this.unit;
        }
    }
}

