/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.protocols.api.Request;

public class POP3MessageCommandArguments {
    private final int messageNumber;
    private final Optional<Integer> lineCount;

    public static Optional<POP3MessageCommandArguments> fromRequest(Request request) {
        String parameters = request.getArgument();
        if (parameters == null) {
            return Optional.empty();
        }
        try {
            List args = (List)Splitter.on((char)' ').omitEmptyStrings().trimResults().splitToList((CharSequence)parameters).stream().map(Integer::parseInt).collect(ImmutableList.toImmutableList());
            if (args.size() == 2) {
                return Optional.of(new POP3MessageCommandArguments((Integer)args.get(0), Optional.of((Integer)args.get(1))));
            }
            if (args.size() == 1) {
                return Optional.of(new POP3MessageCommandArguments((Integer)args.get(0), Optional.empty()));
            }
            return Optional.empty();
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }

    private POP3MessageCommandArguments(int messsageNumber, Optional<Integer> lineCount) {
        this.messageNumber = messsageNumber;
        this.lineCount = lineCount;
    }

    int getMessageNumber() {
        return this.messageNumber;
    }

    Optional<Integer> getLineCount() {
        return this.lineCount;
    }
}

