/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public final class DayCounterInfo {
    private final String date;
    private final long[] counters;

    public static String toJSON(DayCounterInfo[] infos) {
        JsonObjectBuilder json = JsonLoader.createObjectBuilder();
        JsonArrayBuilder counters = JsonLoader.createArrayBuilder();
        for (DayCounterInfo info : infos) {
            JsonArrayBuilder counter = JsonLoader.createArrayBuilder();
            for (long c : info.getCounters()) {
                counter.add(c);
            }
            JsonObjectBuilder dci = JsonLoader.createObjectBuilder().add("date", info.getDate()).add("counters", counter);
            counters.add(dci);
        }
        json.add("dayCounters", counters);
        return json.build().toString();
    }

    public static DayCounterInfo[] fromJSON(String jsonString) {
        JsonObject json = JsonUtil.readJsonObject(jsonString);
        JsonArray dayCounters = json.getJsonArray("dayCounters");
        DayCounterInfo[] infos = new DayCounterInfo[dayCounters.size()];
        for (int i = 0; i < dayCounters.size(); ++i) {
            DayCounterInfo info;
            JsonObject counter = (JsonObject)dayCounters.get(i);
            JsonArray hour = counter.getJsonArray("counters");
            long[] hourCounters = new long[24];
            for (int j = 0; j < 24; ++j) {
                hourCounters[j] = hour.getInt(j);
            }
            infos[i] = info = new DayCounterInfo(counter.getString("date"), hourCounters);
        }
        return infos;
    }

    public DayCounterInfo(String date, long[] counters) {
        this.date = date;
        this.counters = counters;
    }

    public String getDate() {
        return this.date;
    }

    public long[] getCounters() {
        return this.counters;
    }
}

