/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public abstract class FileUtil {
    private static final int BUFFER_SIZE = 16384;

    public static boolean removeDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!(file2.isDirectory() ? !FileUtil.removeDirectory(file2) : !file2.delete())) continue;
                return false;
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File file2, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[16384];
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            FileUtil.limitAccessToOwner(file2);
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
            fileInputStream.close();
            fileInputStream = null;
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean copyDirectory(StorageFactory storageFactory, StorageFile storageFile, File file, byte[] byArray, String[] stringArray, boolean bl) {
        if (storageFile == null) {
            return false;
        }
        if (!storageFile.exists()) {
            return true;
        }
        if (!storageFile.isDirectory()) {
            return false;
        }
        if (file.exists()) {
            return false;
        }
        if (!file.mkdirs()) {
            return false;
        }
        try {
            FileUtil.limitAccessToOwner(file);
        }
        catch (IOException iOException) {
            return false;
        }
        String[] stringArray2 = storageFile.list();
        if (stringArray2 != null) {
            if (byArray == null) {
                byArray = new byte[16384];
            }
            block2: for (int i = 0; i < stringArray2.length; ++i) {
                StorageFile storageFile2;
                String string = stringArray2[i];
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (string.equals(stringArray[j])) continue block2;
                    }
                }
                if (!((storageFile2 = storageFactory.newStorageFile(storageFile, string)).isDirectory() ? bl && !FileUtil.copyDirectory(storageFactory, storageFile2, new File(file, string), byArray, stringArray, bl) : !FileUtil.copyFile(storageFactory, storageFile2, new File(file, string), byArray))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(StorageFactory storageFactory, StorageFile storageFile, File file) {
        return FileUtil.copyFile(storageFactory, storageFile, file, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(StorageFactory storageFactory, StorageFile storageFile, File file, byte[] byArray) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = storageFile.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            FileUtil.limitAccessToOwner(file);
            if (byArray == null) {
                byArray = new byte[16384];
            }
            int n = inputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            inputStream = null;
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean copyDirectory(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile) {
        return FileUtil.copyDirectory(writableStorageFactory, file, storageFile, null, null);
    }

    public static boolean copyDirectory(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile, byte[] byArray, String[] stringArray) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        if (storageFile.exists()) {
            return false;
        }
        if (!storageFile.mkdirs()) {
            return false;
        }
        try {
            storageFile.limitAccessToOwner();
        }
        catch (IOException iOException) {
            return false;
        }
        String[] stringArray2 = file.list();
        if (stringArray2 != null) {
            if (byArray == null) {
                byArray = new byte[16384];
            }
            block2: for (int i = 0; i < stringArray2.length; ++i) {
                File file2;
                String string = stringArray2[i];
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (string.equals(stringArray[j])) continue block2;
                    }
                }
                if (!((file2 = new File(file, string)).isDirectory() ? !FileUtil.copyDirectory(writableStorageFactory, file2, writableStorageFactory.newStorageFile(storageFile, string), byArray, stringArray) : !FileUtil.copyFile(writableStorageFactory, file2, writableStorageFactory.newStorageFile(storageFile, string), byArray))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile) {
        return FileUtil.copyFile(writableStorageFactory, file, storageFile, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile, byte[] byArray) {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = storageFile.getOutputStream();
            if (byArray == null) {
                byArray = new byte[16384];
            }
            int n = ((InputStream)fileInputStream).read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = ((InputStream)fileInputStream).read(byArray);
            }
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
            writableStorageFactory.sync(outputStream, false);
            outputStream.close();
            outputStream = null;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(WritableStorageFactory writableStorageFactory, StorageFile storageFile, StorageFile storageFile2) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = storageFile.getInputStream();
            outputStream = storageFile2.getOutputStream();
            byte[] byArray = new byte[16384];
            int n = inputStream.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            inputStream = null;
            writableStorageFactory.sync(outputStream, false);
            outputStream.close();
            outputStream = null;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static String stripProtocolFromFileName(String string) {
        String string2 = string;
        try {
            URL uRL = new URL(string);
            string2 = uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return string2;
    }

    public static void limitAccessToOwner(File file) throws IOException {
        String string = PropertyUtil.getSystemProperty("derby.storage.useDefaultFilePermissions");
        if (string != null) {
            if (Boolean.parseBoolean(string.trim())) {
                return;
            }
        } else if (!PropertyUtil.getSystemBoolean("derby.__serverStartedFromCmdLine", false)) {
            return;
        }
        if (FileUtil.limitAccessToOwnerViaFile(file)) {
            return;
        }
        FileUtil.limitAccessToOwnerViaFileAttributeView(file);
    }

    private static boolean limitAccessToOwnerViaFile(File file) {
        boolean bl = file.setWritable(false, false);
        bl &= file.setWritable(true, true);
        bl &= file.setReadable(false, false);
        bl &= file.setReadable(true, true);
        if (file.isDirectory()) {
            bl &= file.setExecutable(false, false);
            bl &= file.setExecutable(true, true);
        }
        return bl;
    }

    private static boolean limitAccessToOwnerViaFileAttributeView(File file) throws IOException {
        Path path = file.toPath();
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView != null) {
            EnumSet<PosixFilePermission> enumSet = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
            if (file.isDirectory()) {
                enumSet.add(PosixFilePermission.OWNER_EXECUTE);
            }
            posixFileAttributeView.setPermissions(enumSet);
            return true;
        }
        AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        if (aclFileAttributeView != null) {
            AclEntry aclEntry = AclEntry.newBuilder().setPrincipal(Files.getOwner(path, new LinkOption[0])).setType(AclEntryType.ALLOW).setPermissions(EnumSet.allOf(AclEntryPermission.class)).build();
            aclFileAttributeView.setAcl(Collections.singletonList(aclEntry));
            return true;
        }
        return false;
    }
}

