/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.memory;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.RecipientId;
import reactor.core.publisher.Mono;

public class MemoryNotificationRegistry
implements NotificationRegistry {
    private final ZonedDateTimeProvider zonedDateTimeProvider;
    private final Multimap<AccountId, Entry> registrations;

    @Inject
    public MemoryNotificationRegistry(ZonedDateTimeProvider zonedDateTimeProvider) {
        this.zonedDateTimeProvider = zonedDateTimeProvider;
        this.registrations = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    }

    public Mono<Void> register(AccountId accountId, RecipientId recipientId, Optional<ZonedDateTime> expiryDate) {
        this.registrations.put((Object)accountId, (Object)new Entry(recipientId, expiryDate));
        return Mono.empty();
    }

    public Mono<Boolean> isRegistered(AccountId accountId, RecipientId recipientId) {
        ZonedDateTime currentTime = (ZonedDateTime)this.zonedDateTimeProvider.get();
        return Mono.just((Object)this.registrations.get((Object)accountId).stream().filter(entry -> entry.getRecipientId().equals((Object)recipientId)).map(Entry::getExpiryDate).findAny().filter(optional -> optional.map(registrationEnd -> this.isStrictlyBefore(currentTime, (ZonedDateTime)registrationEnd)).orElse(true)).isPresent());
    }

    private boolean isStrictlyBefore(ZonedDateTime currentTime, ZonedDateTime registrationEnd) {
        return !currentTime.isAfter(registrationEnd);
    }

    public Mono<Void> flush(AccountId accountId) {
        this.registrations.removeAll((Object)accountId);
        return Mono.empty();
    }

    public static class Entry {
        private final RecipientId recipientId;
        private final Optional<ZonedDateTime> expiryDate;

        public Entry(RecipientId recipientId, Optional<ZonedDateTime> expiryDate) {
            this.recipientId = recipientId;
            this.expiryDate = expiryDate;
        }

        public RecipientId getRecipientId() {
            return this.recipientId;
        }

        public Optional<ZonedDateTime> getExpiryDate() {
            return this.expiryDate;
        }
    }
}

