/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.metrics.api.MetricFactory;

public abstract class AbstractSubscriptionProcessor<R extends ImapRequest>
extends AbstractMailboxProcessor<R> {
    private final SubscriptionManager subscriptionManager;

    public AbstractSubscriptionProcessor(Class<R> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(acceptableClass, next, mailboxManager, factory, metricFactory);
        this.subscriptionManager = subscriptionManager;
    }

    protected SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @Override
    protected final void processRequest(R request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mSession = session.getMailboxSession();
        this.getSubscriptionManager().startProcessingRequest(mSession);
        this.doProcessRequest(request, session, responder);
        this.getSubscriptionManager().endProcessingRequest(mSession);
    }

    protected abstract void doProcessRequest(R var1, ImapSession var2, ImapProcessor.Responder var3);
}

