/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KmsClient;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;

public final class KmsClients {
    private static List<KmsClient> autoClients;
    private static final CopyOnWriteArrayList<KmsClient> clients;

    public static void add(KmsClient client) {
        clients.add(client);
    }

    public static KmsClient get(String keyUri) throws GeneralSecurityException {
        for (KmsClient client : clients) {
            if (!client.doesSupport(keyUri)) continue;
            return client;
        }
        throw new GeneralSecurityException("No KMS client does support: " + keyUri);
    }

    public static synchronized KmsClient getAutoLoaded(String keyUri) throws GeneralSecurityException {
        if (autoClients == null) {
            autoClients = KmsClients.loadAutoKmsClients();
        }
        for (KmsClient client : autoClients) {
            if (!client.doesSupport(keyUri)) continue;
            return client;
        }
        throw new GeneralSecurityException("No KMS client does support: " + keyUri);
    }

    private static List<KmsClient> loadAutoKmsClients() {
        ArrayList<KmsClient> clients = new ArrayList<KmsClient>();
        ServiceLoader<KmsClient> clientLoader = ServiceLoader.load(KmsClient.class);
        Iterator<KmsClient> i = clientLoader.iterator();
        while (i.hasNext()) {
            clients.add(i.next());
        }
        return Collections.unmodifiableList(clients);
    }

    static {
        clients = new CopyOnWriteArrayList();
    }
}

