/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.library;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.mailet.HostAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MXHostAddressIterator
implements Iterator<HostAddress> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MXHostAddressIterator.class);
    public static final boolean SMTP_ONLY = false;
    private final Iterator<HostAddress> addresses;

    public MXHostAddressIterator(Iterator<String> hosts, DNSService dns, boolean useSingleIP) {
        this(hosts, dns, useSingleIP, false);
    }

    public MXHostAddressIterator(Iterator<String> hosts, DNSService dns, boolean useSingleIP, boolean smtps) {
        Preconditions.checkNotNull(hosts, (Object)"Hosts is null");
        Preconditions.checkNotNull((Object)dns, (Object)"Dns is null");
        ArrayList hAddresses = Lists.newArrayList();
        while (hosts.hasNext()) {
            String nextHostname = hosts.next();
            Map.Entry<String, Optional<String>> hostAndPort = MXHostAddressIterator.extractHostAndPort(nextHostname);
            try {
                Collection addrs = useSingleIP ? ImmutableList.of((Object)dns.getByName(hostAndPort.getKey())) : dns.getAllByName(hostAndPort.getKey());
                for (InetAddress addr : addrs) {
                    if (smtps) {
                        hAddresses.add(new HostAddress(hostAndPort.getKey(), "smtps://" + addr.getHostAddress() + ":" + hostAndPort.getValue().orElse("465")));
                    }
                    hAddresses.add(new HostAddress(hostAndPort.getKey(), "smtp://" + addr.getHostAddress() + ":" + hostAndPort.getValue().orElse("25")));
                }
            }
            catch (UnknownHostException uhe) {
                String logBuffer = "Couldn't resolve IP address for discovered host " + hostAndPort.getKey() + ".";
                LOGGER.error(logBuffer);
            }
        }
        this.addresses = hAddresses.iterator();
    }

    private static Map.Entry<String, Optional<String>> extractHostAndPort(String nextHostname) {
        String hostname;
        Optional<Object> port;
        int idx = nextHostname.indexOf(58);
        if (idx > 0) {
            port = Optional.of(nextHostname.substring(idx + 1));
            hostname = nextHostname.substring(0, idx);
        } else {
            hostname = nextHostname;
            port = Optional.empty();
        }
        return Maps.immutableEntry((Object)hostname, port);
    }

    @Override
    public boolean hasNext() {
        return this.addresses.hasNext();
    }

    @Override
    public HostAddress next() {
        return this.addresses.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported by this iterator");
    }
}

