/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.Delivery;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.rabbitmq.RabbitFluxException;
import reactor.rabbitmq.SubscriberState;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class RpcClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcClient.class);
    private final Mono<Channel> channelMono;
    private final String exchange;
    private final String routingKey;
    private final String replyTo = "amq.rabbitmq.reply-to";
    private final AtomicBoolean consumerSetUp = new AtomicBoolean(false);
    private final ConcurrentMap<String, RpcSubscriber> subscribers = new ConcurrentHashMap<String, RpcSubscriber>();
    private final AtomicReference<String> consumerTag = new AtomicReference();
    private final Supplier<String> correlationIdSupplier;
    private final Lock channelLock = new ReentrantLock();
    private final CountDownLatch consumerSetLatch = new CountDownLatch(1);

    public RpcClient(Mono<Channel> channelMono, String exchange, String routingKey, Supplier<String> correlationIdSupplier) {
        this.channelMono = channelMono;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.correlationIdSupplier = correlationIdSupplier;
    }

    public RpcClient(Mono<Channel> channelMono, String exchange, String routingKey) {
        this(channelMono, exchange, routingKey, RpcClient.defaultCorrelationProvider());
    }

    private static final Supplier<String> defaultCorrelationProvider() {
        AtomicLong correlationId = new AtomicLong(0L);
        return () -> String.valueOf(correlationId.getAndIncrement());
    }

    public Mono<Delivery> rpc(Publisher<RpcRequest> request) {
        return this.channelMono.flatMap(channel -> new RpcOperator(request, (Channel)channel));
    }

    @Override
    public void close() {
        if (!this.subscribers.isEmpty()) {
            LOGGER.warn("Closing RPC client with outstanding request(s): " + this.subscribers.keySet());
        }
        if (this.consumerTag.get() != null) {
            try {
                Channel channel = (Channel)this.channelMono.block();
                this.lockChannel();
                try {
                    channel.basicCancel(this.consumerTag.get());
                }
                finally {
                    this.unlockChannel();
                }
            }
            catch (IOException e) {
                throw new RabbitFluxException(e);
            }
        }
    }

    protected void lockChannel() {
        this.channelLock.lock();
    }

    protected void unlockChannel() {
        this.channelLock.unlock();
    }

    private class RpcOperator
    extends MonoOperator<RpcRequest, Delivery> {
        private final Channel channel;

        protected RpcOperator(Publisher<RpcRequest> source, Channel channel) {
            super(Mono.from(source));
            this.channel = channel;
        }

        public void subscribe(CoreSubscriber<? super Delivery> actual) {
            this.source.subscribe((CoreSubscriber)new RpcSubscriber(this.channel, (Subscriber<? super Delivery>)actual));
        }
    }

    private class RpcSubscriber
    implements CoreSubscriber<RpcRequest> {
        private final AtomicReference<SubscriberState> state = new AtomicReference<SubscriberState>(SubscriberState.INIT);
        private final AtomicReference<Throwable> firstException = new AtomicReference();
        private final Channel channel;
        private final Subscriber<? super Delivery> subscriber;
        private final AtomicBoolean received = new AtomicBoolean(false);

        RpcSubscriber(Channel channel, Subscriber<? super Delivery> subscriber) {
            this.channel = channel;
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSubscribe(Subscription s) {
            if (RpcClient.this.consumerSetUp.compareAndSet(false, true)) {
                DeliverCallback deliver = (consumerTag, delivery) -> {
                    String correlationId = delivery.getProperties().getCorrelationId();
                    RpcSubscriber rpcSubscriber = (RpcSubscriber)RpcClient.this.subscribers.remove(correlationId);
                    if (rpcSubscriber == null) {
                        throw new RabbitFluxException("No outstanding request for correlation ID " + correlationId);
                    }
                    rpcSubscriber.subscriber.onNext((Object)delivery);
                    rpcSubscriber.received.set(true);
                };
                try {
                    RpcClient.this.lockChannel();
                    try {
                        String ctag = this.channel.basicConsume("amq.rabbitmq.reply-to", true, deliver, consumerTag -> {});
                        RpcClient.this.consumerTag.set(ctag);
                    }
                    finally {
                        RpcClient.this.unlockChannel();
                    }
                }
                catch (IOException e) {
                    this.handleError(e);
                }
                finally {
                    RpcClient.this.consumerSetLatch.countDown();
                }
            } else {
                try {
                    if (!RpcClient.this.consumerSetLatch.await(60L, TimeUnit.SECONDS)) {
                        LOGGER.warn("Consumer setup not finished in 60 seconds, moving on.");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.state.set(SubscriberState.ACTIVE);
            this.subscriber.onSubscribe(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(RpcRequest request) {
            if (this.checkComplete(request)) {
                return;
            }
            try {
                String correlationId = (String)RpcClient.this.correlationIdSupplier.get();
                AMQP.BasicProperties properties = request.properties;
                properties = (properties == null ? new AMQP.BasicProperties.Builder() : properties.builder()).correlationId(correlationId).replyTo("amq.rabbitmq.reply-to").build();
                RpcClient.this.subscribers.put(correlationId, this);
                RpcClient.this.lockChannel();
                try {
                    this.channel.basicPublish(RpcClient.this.exchange, RpcClient.this.routingKey, properties, request.body);
                }
                finally {
                    RpcClient.this.unlockChannel();
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }

        public void onError(Throwable throwable) {
            if (this.state.compareAndSet(SubscriberState.ACTIVE, SubscriberState.COMPLETE) || this.state.compareAndSet(SubscriberState.OUTBOUND_DONE, SubscriberState.COMPLETE)) {
                this.subscriber.onError(throwable);
            } else if (this.firstException.compareAndSet(null, throwable) && this.state.get() == SubscriberState.COMPLETE) {
                Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
            }
        }

        public void onComplete() {
            if (this.state.compareAndSet(SubscriberState.ACTIVE, SubscriberState.OUTBOUND_DONE) && this.received.get()) {
                this.maybeComplete();
            }
        }

        private void maybeComplete() {
            boolean done = this.state.compareAndSet(SubscriberState.OUTBOUND_DONE, SubscriberState.COMPLETE);
            if (done) {
                this.subscriber.onComplete();
            }
        }

        private void handleError(Exception e) {
            LOGGER.error("error during RPC", (Throwable)e);
            boolean complete = this.checkComplete(e);
            this.firstException.compareAndSet(null, e);
            if (!complete) {
                this.onError(e);
            }
        }

        public <T> boolean checkComplete(T t) {
            boolean complete;
            boolean bl = complete = this.state.get() == SubscriberState.COMPLETE;
            if (complete && this.firstException.get() == null) {
                Operators.onNextDropped(t, (Context)this.currentContext());
            }
            return complete;
        }
    }

    public static class RpcRequest {
        private final AMQP.BasicProperties properties;
        private final byte[] body;

        public RpcRequest(@Nullable AMQP.BasicProperties properties, byte[] body) {
            this.properties = properties;
            this.body = body;
        }

        public RpcRequest(byte[] body) {
            this(null, body);
        }
    }
}

