/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LogoutRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class LogoutProcessor
extends AbstractMailboxProcessor<LogoutRequest> {
    public LogoutProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(LogoutRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(LogoutRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        this.getMailboxManager().logout(mailboxSession);
        session.logout();
        this.bye(responder);
        this.okComplete(request, responder);
    }

    @Override
    protected Closeable addContextToMDC(LogoutRequest request) {
        return MDCBuilder.create().addToContext("action", "LOGOUT").build();
    }
}

