/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.mailet.base.GenericRecipientMatcher;

public class RecipientDomainIs
extends GenericRecipientMatcher {
    private Collection<Domain> recipientDomains;

    public void init() {
        String condition = this.getCondition();
        Preconditions.checkNotNull((Object)condition, (Object)"'condition' should not be null");
        this.recipientDomains = this.parseDomainsList(condition);
    }

    @VisibleForTesting
    Collection<Domain> parseDomainsList(String condition) {
        return (Collection)Splitter.onPattern((String)"(, |,| )").omitEmptyStrings().splitToList((CharSequence)condition).stream().map(Domain::of).collect(ImmutableList.toImmutableList());
    }

    public boolean matchRecipient(MailAddress recipient) {
        return this.recipientDomains.contains(recipient.getDomain());
    }
}

