/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests;

import org.apache.commons.logging.Log;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.tests.ExecutableTest;

public abstract class AbstractTest
implements ExecutableTest {
    @Override
    public boolean execute(MailAdapter mail, Arguments arguments, SieveContext context) throws SieveException {
        this.validateArguments(arguments, context);
        return this.executeBasic(mail, arguments, context);
    }

    protected abstract boolean executeBasic(MailAdapter var1, Arguments var2, SieveContext var3) throws SieveException;

    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
        if (!arguments.getArgumentList().isEmpty()) {
            Log logger = context.getLog();
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Unexpected arguments for " + this.getClass().getName()));
            }
            context.getCoordinate().logDiagnosticsInfo(logger);
            logger.debug((Object)arguments);
            String message = context.getCoordinate().addStartLineAndColumn("Found unexpected arguments.");
            throw new SyntaxException(message);
        }
    }
}

