/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.james.mime4j.ExampleMessageTestCaseFactory;

public class ExampleMessageTestSuiteBuilder {
    private final ExampleMessageTestCaseFactory testFactory;

    public ExampleMessageTestSuiteBuilder(ExampleMessageTestCaseFactory testFactory) {
        this.testFactory = testFactory;
    }

    public TestSuite build() throws IOException {
        TestSuite suite = new TestSuite();
        this.addAllTests(suite);
        return suite;
    }

    private void addAllTests(TestSuite testSuite) throws IOException {
        this.addTests(testSuite, "/testmsgs");
        this.addTests(testSuite, "/mimetools-testmsgs");
    }

    private void addTests(TestSuite testSuite, String testsFolder) throws IOException {
        block2: {
            URL resource;
            block3: {
                File[] files;
                resource = ExampleMessageTestSuiteBuilder.class.getResource(testsFolder);
                if (resource == null) break block2;
                if (!resource.getProtocol().equalsIgnoreCase("file")) break block3;
                File dir = new File(resource.getFile());
                for (File f : files = dir.listFiles()) {
                    if (!f.getName().endsWith(".msg")) continue;
                    testSuite.addTest((Test)this.testFactory.create(f, f.toURL()));
                }
                break block2;
            }
            if (!resource.getProtocol().equalsIgnoreCase("jar")) break block2;
            JarURLConnection conn = (JarURLConnection)resource.openConnection();
            JarFile jar = conn.getJarFile();
            Enumeration<JarEntry> it = jar.entries();
            while (it.hasMoreElements()) {
                JarEntry entry = it.nextElement();
                String s = "/" + entry.toString();
                File f = new File(s);
                if (!s.startsWith(testsFolder) || !s.endsWith(".msg")) continue;
                testSuite.addTest((Test)this.testFactory.create(f, new URL("jar:file:" + jar.getName() + "!" + s)));
            }
        }
    }
}

