/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.MailetUtil;

public class TooManyRecipients
extends GenericMatcher {
    private int maximumRecipientCount;

    public void init() throws MessagingException {
        this.maximumRecipientCount = MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)this.getCondition());
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        if (mail.getRecipients().size() > this.maximumRecipientCount) {
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }
}

