<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

How To Create A Release
=======================
<!-- line width set to 120 characters. please break lines so that this file also looks good in vi -->

<!-- MACRO{toc} -->

Prerequisites for release managers
----------------------------------
You need to be a Jackrabbit committer to prepare and perform a release, but anyone is welcome to help test the release
candidates and comment on the release plans.

You should have a code signing key that is included in the Jackrabbit KEYS file. See [Appendix A](#A) at the end of 
this page for more details.

You also need to tell Maven your Subversion credentials needed for deploying artifacts to the Nexus server at 
https://repository.apache.org/. See [Appendix B](#B) for the required settings.

Release management tasks
------------------------
1. Make sure that an appropriate version for the release is entered in [Jira][3] and that all the related issues have
   been resolved.
   
2. Create or update a `RELEASE-NOTES.md` file in the root folder of the project to be released. When done, commit the
   file. See previous release notes for examples of what to include. The release note report in [Jira][3] is a useful
   source of required information.
   
3. Build and deploy the release artifacts with Maven (see below).

    The release is built using the Maven release plugin. See the [Releasing a Maven project][4] guide for more
    details. Make sure you have added the pgp key information in you maven settings file, especially if you have 
    more than one key installed locally. See [Appendix B](#B) for the details.

    1. (optional, prepare your environment. e.g.: `$ export version=1.0.0`)
    2. Execute `mvn clean deploy -Papache-release -Dmaven.deploy.skip=true`. This tests if the release would work.
    3. Execute `mvn release:prepare`. This will update the POM files and tag the release in svn (btw: specifying the 
        release version on the commandline doesn't update the module poms anymore lately).
    4. Execute `mvn release:perform -Papache-release`. This will build the tagged release and deploy the artifacts to
        a new staging repository on _repository.apache.org_. 
        After the build, login to [https://repository.apache.org/][2] and you should see it there.
    
        The non-Maven release artifacts are automatically copied to `/.../target/checkout/target/$version`

4. Close the [staged repository][2] on _repository.apache.org_.  
   Use `Apache Jackrabbit FileVault Package Maven Plugin ${version} RC` as comment.
   
5. Upload the artifacts to https://dist.apache.org/repos/dist/dev/jackrabbit/filevault-package-maven-plugin via SVN
       
        svn co https://dist.apache.org/repos/dist/dev/jackrabbit/filevault-package-maven-plugin dist-dev-filevault-plugin
        cd dist-dev-filevault-plugin
        cp -r /path/to/jackrabbit/filevault-package-maven-plugin/target/checkout/target/$version $version
        svn add $version
        svn commit -m "Apache Jackrabbit Filevault Package Maven Plugin $version release candidate" $version
       
6. Start the vote thread, wait **72 hours**. See the `vote.txt` template generated by the Maven build.

7. If the vote fails (easy case first):
    1. remove the release tag from Git
    2. delete the RC from _dist.apache.org_
        ````
        svn rm https://dist.apache.org/repos/dist/dev/jackrabbit/filevault-package-maven-plugin/$version
        ````
    3. and drop the staged repository
    4. done 
 
8. If the vote is successful, close the vote by publishing the results

9. copy the release candidate from `dev/jackrabbit` to `release/jackrabbit` in 
   https://dist.apche.org/repos/dist/, and delete any older releases from the same branch 
   (they're automatically archived):

    ```` 
    svn move -m "Apache Jackrabbit FileVault Package Maven Plugin $version" \
        https://dist.apache.org/repos/dist/dev/jackrabbit/filevault-package-maven-plugin/$version \
        https://dist.apache.org/repos/dist/release/jackrabbit/filevault-package-maven-plugin/$version
    ````

10. release the [staged repository][2] for synchronization to Maven central.

11. mark the version as released in [Jira][3]:
    _Jira Project Home_ -> _Project Summary_ -> _Administer Project_. 
        
    Under Versions, you'll see all the defined project versions. 
    From the settings menu, choose *Release* on the version.

12. Close all the issues included in the release: 
    _Jira Project Home_ -> _Change Log_ -> Choose the released version. 
        
    From the issue list you have the option to bulk update all of the included issues. 
    Just *Transition Issues* from *Resolved* to *Closed* and you are done!

13. Update the Jackrabbit web site to point to the new release.

14. Deploy the recent plugin site (see `src/site/readme.md`)

15. Send the release [announcement](#C) **once** the web site have been synced.


Related Links
-------------
* https://www.apache.org/dev/release.html
* https://www.apache.org/dev/release-signing.html
* https://wiki.apache.org/incubator/SigningReleases
* https://www.apache.org/dev/repository-faq.html

  
<a name="A"></a>
Appendix A: Create and add your key to the Jackrabbit KEYS file
---------------------------------------------------------------
Follow these instructions to generate your code signing key and to add it to the Jackrabbit KEYS file.

1. [Generate a code signing key][0] using your _@apache.org_ address as the email and `CODE SIGNING KEY` as the
   comment.
    
2. The Jackrabbit KEYS file is managed in https://svn.apache.org/repos/asf/jackrabbit/dist/KEYS. To modify the file,
   first checkout the `dist` directory:

        svn checkout https://svn.apache.org/repos/asf/jackrabbit/dist
    
3. See the beginning of the KEYS file for instructions on how to append your key to the file.

4. Once you've committed the changes, update the KEYS file on `people.apache.org`:

        umask 002; svn update /www/www.apache.org/dist/jackrabbit
    
5. You are **DONE**, but to see the changes on http://www.apache.org/dist/jackrabbit/KEYS you must wait 2 hours

You should get your key [linked to the Apache web of trust][1]. Once other people have signed your key, you can
update the KEYS file with the signatures you've received.


<a name="B"></a>
Appendix B: Maven settings
--------------------------

    <settings>
    ...
      <servers>
        <!-- To deploy a Jackrabbit snapshot -->
        <server>
          <id>apache.snapshots.https</id>
          <username> <!-- YOUR APACHE LDAP USERNAME --> </username>
          <password> <!-- YOUR APACHE LDAP PASSWORD --> </password>
        </server>
        
        <!-- To stage a Jackrabbit release -->
        <server>
          <id>apache.releases.https</id>
          <username> <!-- YOUR APACHE LDAP USERNAME --> </username>
          <password> <!-- YOUR APACHE LDAP PASSWORD --> </password>
        </server>
        
        <!-- used for gpg code signing key -->
        <!-- see: https://maven.apache.org/plugins/maven-gpg-plugin/usage.html -->
        <server>
            <id> <!-- YOUR KEYNAME --> </id>
            <passphrase> <!-- CLEAR OR ENCRYPTED TEXT --> </passphrase>
        </server>
        ...
        <profiles>
            <profile>
                <id>apache-release</id>
                <properties>
                    <gpg.keyname> <!-- YOUR KEYNAME --> </gpg.keyname>
                </properties>
            </profile>
          </profile>
          ...
        </profiles>
      </servers>
    </settings>

<a name="C"></a>
Appendix C: Announce Mail Template
----------------------------------
**Note**: Copy paste the current release notes; only include the changes of this release.

```
To: dev@jackrabbit.apache.org, users@jackrabbit.apache.org, announce@apache.org
Reply-To: dev@jackrabbit.apache.org
Subject: [ANNOUNCE] Apache Jackrabbit FileVault Package Maven Plugin $version released

The Apache Jackrabbit community is pleased to announce the release of
Apache Jackrabbit FileVault Package Maven Plugin $version. The release is available for download at:

   http://jackrabbit.apache.org/jcr/downloads.html#vltplg

See the full release notes below for details about this release:


Release Notes -- Apache Jackrabbit FileVault Package Maven Plugin -- Version $version
==================================================================================

Introduction
------------
The Apache Jackrabbit FileVault package maven plugin is an Apache maven plugin that simplifies the creation of
content package maven artifacts. The content packages can later be used to install content into a JCR repository
using the Apache Jackrabbit FileVault packaging runtime.

Changes in Jackrabbit FileVault Package Maven Plugin $version
----------------------------------------------------------

#### Bug Fixes
* [JCRVLT-218] Repository structure package satisfies too aggressively
* [JCRVLT-219] Internal ancestors not used for dependency validation
* [JCRVLT-222] analyze-classes goal should be marked as ignored for m2e
* [JCRVLT-237] Fix description on how import-package manifests are generated
* [JCRVLT-241] Goal analyze-classes: Dependencies with type "bundle" not correctly considered
* [JCRVLT-242] Link for the web access of Jackrabbit's FileVault Package source repository is wrong
* [JCRVLT-244] Package Maven Plugin: Fix resource leaks in integration tests
* [JCRVLT-245] Package Maven Plugin: ProjectBuilder.verifyPackageProperty swaps expected/actual value
* [JCRVLT-253] Problems with Configuration inside an Execution with Filters

#### Improvements
* [JCRVLT-217] Create tests for JCRVLT-207 (HTL) as soon as plugin is released
* [JCRVLT-224] Use filevault-core instead of copy-pasting code
* [JCRVLT-231] Clarify repositoryStructurePackages parameter
* [JCRVLT-234] Remove irrelevant @Parameter annotations on field in classes which are not mojos
* [JCRVLT-236] Package Maven Plugin: Improve packageType param documentation
* [JCRVLT-238] Remove classesDirectory parameter
* [JCRVLT-243] VaultMojo: extend javadoc for all complex type parameters
* [JCRVLT-252] Package Maven Plugin: Update to htl-maven-plugin 1.1.2

#### New Features
* [JCRVLT-230] Allow to give an explicit directory as source for META-INF/vault
* [JCRVLT-239] Package Maven Plugin: Add "accessControlHandling" property
* [JCRVLT-240] Package Maven Plugin: Support for package thumbnails

Release Contents
----------------
This release consists of a single source archive packaged as a zip file.
The archive can be unpacked with the jar tool from your JDK installation.
See the [README](./README.md) file for instructions on how to build this release.

The source archive is accompanied by SHA1 and MD5 checksums and a PGP
signature that you can use to verify the authenticity of your download.
The public key used for the PGP signature can be found at
https://www.apache.org/dist/jackrabbit/KEYS

About Apache Jackrabbit
-----------------------
Apache Jackrabbit is a fully conforming implementation of the Content
Repository for Java Technology API (JCR). A content repository is a
hierarchical content store with support for structured and unstructured
content, full text search, versioning, transactions, observation, and
more.

For more information, visit http://jackrabbit.apache.org/

About The Apache Software Foundation
------------------------------------
Established in 1999, The Apache Software Foundation provides organizational,
legal, and financial support for more than 100 freely-available,
collaboratively-developed Open Source projects. The pragmatic Apache License
enables individual and commercial users to easily deploy Apache software;
the Foundation's intellectual property framework limits the legal exposure
of its 2,500+ contributors.

For more information, visit http://www.apache.org/

Trademarks
----------
Apache Jackrabbit, Jackrabbit, Apache, the Apache feather logo, and the Apache
Jackrabbit project logo are trademarks of The Apache Software Foundation.

```

[0]: http://www.apache.org/dev/release-signing.html#generate
[1]: http://www.apache.org/dev/release-signing.html#apache-wot
[2]: https://repository.apache.org/index.html#stagingRepositories
[3]: https://issues.apache.org/jira/browse/JCRVLT
[4]: http://maven.apache.org/developers/release/releasing.html
