/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Match;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.PatternVisitor;

public class CapturePattern<T>
extends Pattern<T> {
    private final Capture<T> capture;

    public CapturePattern(Capture<T> capture, Pattern<T> previous) {
        super(previous);
        this.capture = Objects.requireNonNull(capture, "capture is null");
    }

    public Capture<T> capture() {
        return this.capture;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        Captures newCaptures = captures.addAll(Captures.ofNullable(this.capture, object));
        return Stream.of(Match.of(newCaptures));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitCapture(this);
    }
}

