// Code generated by protoc-gen-go. DO NOT EDIT.
// source: incubator-yunikorn-scheduler-interface/si.proto

package si // import "lib/go/si"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import descriptorpb "google.golang.org/protobuf/types/descriptorpb"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type TerminationType int32

const (
	TerminationType_UNKNOWN_TERMINATION_TYPE TerminationType = 0
	TerminationType_STOPPED_BY_RM            TerminationType = 1
	TerminationType_TIMEOUT                  TerminationType = 2
	TerminationType_PREEMPTED_BY_SCHEDULER   TerminationType = 3
	TerminationType_PLACEHOLDER_REPLACED     TerminationType = 4
)

var TerminationType_name = map[int32]string{
	0: "UNKNOWN_TERMINATION_TYPE",
	1: "STOPPED_BY_RM",
	2: "TIMEOUT",
	3: "PREEMPTED_BY_SCHEDULER",
	4: "PLACEHOLDER_REPLACED",
}
var TerminationType_value = map[string]int32{
	"UNKNOWN_TERMINATION_TYPE": 0,
	"STOPPED_BY_RM":            1,
	"TIMEOUT":                  2,
	"PREEMPTED_BY_SCHEDULER":   3,
	"PLACEHOLDER_REPLACED":     4,
}

func (x TerminationType) String() string {
	return proto.EnumName(TerminationType_name, int32(x))
}
func (TerminationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{0}
}

// Action from RM
type NodeInfo_ActionFromRM int32

const (
	// ActionFromRM not set
	NodeInfo_UNKNOWN_ACTION_FROM_RM NodeInfo_ActionFromRM = 0
	// Create Node
	NodeInfo_CREATE NodeInfo_ActionFromRM = 1
	// Update node resources, attributes.
	NodeInfo_UPDATE NodeInfo_ActionFromRM = 2
	// Do not allocate new allocations on the node.
	NodeInfo_DRAIN_NODE NodeInfo_ActionFromRM = 3
	// Decomission node, it will immediately stop allocations on the node and
	// remove the node from schedulable lists.
	NodeInfo_DECOMISSION NodeInfo_ActionFromRM = 4
	// From Draining state to SCHEDULABLE state.
	// If node is not in draining state, error will be thrown
	NodeInfo_DRAIN_TO_SCHEDULABLE NodeInfo_ActionFromRM = 5
)

var NodeInfo_ActionFromRM_name = map[int32]string{
	0: "UNKNOWN_ACTION_FROM_RM",
	1: "CREATE",
	2: "UPDATE",
	3: "DRAIN_NODE",
	4: "DECOMISSION",
	5: "DRAIN_TO_SCHEDULABLE",
}
var NodeInfo_ActionFromRM_value = map[string]int32{
	"UNKNOWN_ACTION_FROM_RM": 0,
	"CREATE":                 1,
	"UPDATE":                 2,
	"DRAIN_NODE":             3,
	"DECOMISSION":            4,
	"DRAIN_TO_SCHEDULABLE":   5,
}

func (x NodeInfo_ActionFromRM) String() string {
	return proto.EnumName(NodeInfo_ActionFromRM_name, int32(x))
}
func (NodeInfo_ActionFromRM) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{24, 0}
}

// container scheduling states
type UpdateContainerSchedulingStateRequest_SchedulingState int32

const (
	// SchedulingState not set
	UpdateContainerSchedulingStateRequest_UNKNOWN_SCHEDULING_STATE UpdateContainerSchedulingStateRequest_SchedulingState = 0
	// the container is being skipped by the scheduler
	UpdateContainerSchedulingStateRequest_SKIPPED UpdateContainerSchedulingStateRequest_SchedulingState = 1
	// the container is scheduled and it has been assigned to a node
	UpdateContainerSchedulingStateRequest_SCHEDULED UpdateContainerSchedulingStateRequest_SchedulingState = 2
	// the container is reserved on some node, but not yet assigned
	UpdateContainerSchedulingStateRequest_RESERVED UpdateContainerSchedulingStateRequest_SchedulingState = 3
	// scheduler has visited all candidate nodes for this container
	// but non of them could satisfy this container's requirement
	UpdateContainerSchedulingStateRequest_FAILED UpdateContainerSchedulingStateRequest_SchedulingState = 4
)

var UpdateContainerSchedulingStateRequest_SchedulingState_name = map[int32]string{
	0: "UNKNOWN_SCHEDULING_STATE",
	1: "SKIPPED",
	2: "SCHEDULED",
	3: "RESERVED",
	4: "FAILED",
}
var UpdateContainerSchedulingStateRequest_SchedulingState_value = map[string]int32{
	"UNKNOWN_SCHEDULING_STATE": 0,
	"SKIPPED":                  1,
	"SCHEDULED":                2,
	"RESERVED":                 3,
	"FAILED":                   4,
}

func (x UpdateContainerSchedulingStateRequest_SchedulingState) String() string {
	return proto.EnumName(UpdateContainerSchedulingStateRequest_SchedulingState_name, int32(x))
}
func (UpdateContainerSchedulingStateRequest_SchedulingState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{30, 0}
}

type EventRecord_Type int32

const (
	// EventRecord Type not set
	EventRecord_UNKNOWN_EVENTRECORD_TYPE EventRecord_Type = 0
	EventRecord_REQUEST                  EventRecord_Type = 1
	EventRecord_APP                      EventRecord_Type = 2
	EventRecord_NODE                     EventRecord_Type = 3
	EventRecord_QUEUE                    EventRecord_Type = 4
)

var EventRecord_Type_name = map[int32]string{
	0: "UNKNOWN_EVENTRECORD_TYPE",
	1: "REQUEST",
	2: "APP",
	3: "NODE",
	4: "QUEUE",
}
var EventRecord_Type_value = map[string]int32{
	"UNKNOWN_EVENTRECORD_TYPE": 0,
	"REQUEST":                  1,
	"APP":                      2,
	"NODE":                     3,
	"QUEUE":                    4,
}

func (x EventRecord_Type) String() string {
	return proto.EnumName(EventRecord_Type_name, int32(x))
}
func (EventRecord_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{33, 0}
}

//
// service MetricsService {
// }
type RegisterResourceManagerRequest struct {
	// An ID which can uniquely identify a RM **cluster**. (For example, if a RM cluster has multiple manager instances for HA purpose, they should use the same information when do registration).
	// If RM register with the same ID, all previous scheduling state in memory will be cleaned up, and expect RM report full scheduling state after registration.
	RmID string `protobuf:"bytes,1,opt,name=rmID,proto3" json:"rmID,omitempty"`
	// Version of RM scheduler interface client.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Policy group name:
	// This defines which policy to use. Policy should be statically configured. (Think about network security group concept of ec2).
	// Different RMs can refer to the same policyGroup if their static configuration is identical.
	PolicyGroup          string   `protobuf:"bytes,3,opt,name=policyGroup,proto3" json:"policyGroup,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResourceManagerRequest) Reset()         { *m = RegisterResourceManagerRequest{} }
func (m *RegisterResourceManagerRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterResourceManagerRequest) ProtoMessage()    {}
func (*RegisterResourceManagerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{0}
}
func (m *RegisterResourceManagerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResourceManagerRequest.Unmarshal(m, b)
}
func (m *RegisterResourceManagerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResourceManagerRequest.Marshal(b, m, deterministic)
}
func (dst *RegisterResourceManagerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResourceManagerRequest.Merge(dst, src)
}
func (m *RegisterResourceManagerRequest) XXX_Size() int {
	return xxx_messageInfo_RegisterResourceManagerRequest.Size(m)
}
func (m *RegisterResourceManagerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResourceManagerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResourceManagerRequest proto.InternalMessageInfo

func (m *RegisterResourceManagerRequest) GetRmID() string {
	if m != nil {
		return m.RmID
	}
	return ""
}

func (m *RegisterResourceManagerRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *RegisterResourceManagerRequest) GetPolicyGroup() string {
	if m != nil {
		return m.PolicyGroup
	}
	return ""
}

// Upon success, scheduler returns RegisterResourceManagerResponse to RM, otherwise RM receives exception.
type RegisterResourceManagerResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResourceManagerResponse) Reset()         { *m = RegisterResourceManagerResponse{} }
func (m *RegisterResourceManagerResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterResourceManagerResponse) ProtoMessage()    {}
func (*RegisterResourceManagerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{1}
}
func (m *RegisterResourceManagerResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResourceManagerResponse.Unmarshal(m, b)
}
func (m *RegisterResourceManagerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResourceManagerResponse.Marshal(b, m, deterministic)
}
func (dst *RegisterResourceManagerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResourceManagerResponse.Merge(dst, src)
}
func (m *RegisterResourceManagerResponse) XXX_Size() int {
	return xxx_messageInfo_RegisterResourceManagerResponse.Size(m)
}
func (m *RegisterResourceManagerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResourceManagerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResourceManagerResponse proto.InternalMessageInfo

type AllocationRequest struct {
	// New allocation requests or replace existing allocation request (if allocationID is same)
	Asks []*AllocationAsk `protobuf:"bytes,1,rep,name=asks,proto3" json:"asks,omitempty"`
	// Allocations can be released.
	Releases *AllocationReleasesRequest `protobuf:"bytes,2,opt,name=releases,proto3" json:"releases,omitempty"`
	// ID of RM, this will be used to identify which RM of the request comes from.
	RmID                 string   `protobuf:"bytes,3,opt,name=rmID,proto3" json:"rmID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationRequest) Reset()         { *m = AllocationRequest{} }
func (m *AllocationRequest) String() string { return proto.CompactTextString(m) }
func (*AllocationRequest) ProtoMessage()    {}
func (*AllocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{2}
}
func (m *AllocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationRequest.Unmarshal(m, b)
}
func (m *AllocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationRequest.Marshal(b, m, deterministic)
}
func (dst *AllocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationRequest.Merge(dst, src)
}
func (m *AllocationRequest) XXX_Size() int {
	return xxx_messageInfo_AllocationRequest.Size(m)
}
func (m *AllocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationRequest proto.InternalMessageInfo

func (m *AllocationRequest) GetAsks() []*AllocationAsk {
	if m != nil {
		return m.Asks
	}
	return nil
}

func (m *AllocationRequest) GetReleases() *AllocationReleasesRequest {
	if m != nil {
		return m.Releases
	}
	return nil
}

func (m *AllocationRequest) GetRmID() string {
	if m != nil {
		return m.RmID
	}
	return ""
}

type ApplicationRequest struct {
	// RM should explicitly add application when allocation request also explictly belongs to application.
	// This is optional if allocation request doesn't belong to a application. (Independent allocation)
	New []*AddApplicationRequest `protobuf:"bytes,1,rep,name=new,proto3" json:"new,omitempty"`
	// RM can also remove applications, all allocation/allocation requests associated with the application will be removed
	Remove []*RemoveApplicationRequest `protobuf:"bytes,2,rep,name=remove,proto3" json:"remove,omitempty"`
	// ID of RM, this will be used to identify which RM of the request comes from.
	RmID                 string   `protobuf:"bytes,3,opt,name=rmID,proto3" json:"rmID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationRequest) Reset()         { *m = ApplicationRequest{} }
func (m *ApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationRequest) ProtoMessage()    {}
func (*ApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{3}
}
func (m *ApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationRequest.Unmarshal(m, b)
}
func (m *ApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationRequest.Marshal(b, m, deterministic)
}
func (dst *ApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationRequest.Merge(dst, src)
}
func (m *ApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_ApplicationRequest.Size(m)
}
func (m *ApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationRequest proto.InternalMessageInfo

func (m *ApplicationRequest) GetNew() []*AddApplicationRequest {
	if m != nil {
		return m.New
	}
	return nil
}

func (m *ApplicationRequest) GetRemove() []*RemoveApplicationRequest {
	if m != nil {
		return m.Remove
	}
	return nil
}

func (m *ApplicationRequest) GetRmID() string {
	if m != nil {
		return m.RmID
	}
	return ""
}

type NodeRequest struct {
	// New node can be scheduled. If a node is notified to be "unscheduable", it needs to be part of this field as well.
	Nodes []*NodeInfo `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// ID of RM, this will be used to identify which RM of the request comes from.
	RmID                 string   `protobuf:"bytes,2,opt,name=rmID,proto3" json:"rmID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeRequest) Reset()         { *m = NodeRequest{} }
func (m *NodeRequest) String() string { return proto.CompactTextString(m) }
func (*NodeRequest) ProtoMessage()    {}
func (*NodeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{4}
}
func (m *NodeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeRequest.Unmarshal(m, b)
}
func (m *NodeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeRequest.Marshal(b, m, deterministic)
}
func (dst *NodeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeRequest.Merge(dst, src)
}
func (m *NodeRequest) XXX_Size() int {
	return xxx_messageInfo_NodeRequest.Size(m)
}
func (m *NodeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeRequest proto.InternalMessageInfo

func (m *NodeRequest) GetNodes() []*NodeInfo {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *NodeRequest) GetRmID() string {
	if m != nil {
		return m.RmID
	}
	return ""
}

type AllocationResponse struct {
	// New allocations
	New []*Allocation `protobuf:"bytes,1,rep,name=new,proto3" json:"new,omitempty"`
	// Released allocations, this could be either ack from scheduler when RM asks to terminate some allocations.
	// Or it could be decision made by scheduler (such as preemption or timeout).
	Released []*AllocationRelease `protobuf:"bytes,2,rep,name=released,proto3" json:"released,omitempty"`
	// Released allocation asks(placeholder), when the placeholder allocation times out
	ReleasedAsks []*AllocationAskRelease `protobuf:"bytes,3,rep,name=releasedAsks,proto3" json:"releasedAsks,omitempty"`
	// Rejected allocation requests
	Rejected             []*RejectedAllocationAsk `protobuf:"bytes,4,rep,name=rejected,proto3" json:"rejected,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *AllocationResponse) Reset()         { *m = AllocationResponse{} }
func (m *AllocationResponse) String() string { return proto.CompactTextString(m) }
func (*AllocationResponse) ProtoMessage()    {}
func (*AllocationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{5}
}
func (m *AllocationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationResponse.Unmarshal(m, b)
}
func (m *AllocationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationResponse.Marshal(b, m, deterministic)
}
func (dst *AllocationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationResponse.Merge(dst, src)
}
func (m *AllocationResponse) XXX_Size() int {
	return xxx_messageInfo_AllocationResponse.Size(m)
}
func (m *AllocationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationResponse proto.InternalMessageInfo

func (m *AllocationResponse) GetNew() []*Allocation {
	if m != nil {
		return m.New
	}
	return nil
}

func (m *AllocationResponse) GetReleased() []*AllocationRelease {
	if m != nil {
		return m.Released
	}
	return nil
}

func (m *AllocationResponse) GetReleasedAsks() []*AllocationAskRelease {
	if m != nil {
		return m.ReleasedAsks
	}
	return nil
}

func (m *AllocationResponse) GetRejected() []*RejectedAllocationAsk {
	if m != nil {
		return m.Rejected
	}
	return nil
}

type ApplicationResponse struct {
	// Rejected Applications
	Rejected []*RejectedApplication `protobuf:"bytes,1,rep,name=rejected,proto3" json:"rejected,omitempty"`
	// Accepted Applications
	Accepted []*AcceptedApplication `protobuf:"bytes,2,rep,name=accepted,proto3" json:"accepted,omitempty"`
	// Updated Applications
	Updated              []*UpdatedApplication `protobuf:"bytes,3,rep,name=updated,proto3" json:"updated,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ApplicationResponse) Reset()         { *m = ApplicationResponse{} }
func (m *ApplicationResponse) String() string { return proto.CompactTextString(m) }
func (*ApplicationResponse) ProtoMessage()    {}
func (*ApplicationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{6}
}
func (m *ApplicationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationResponse.Unmarshal(m, b)
}
func (m *ApplicationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationResponse.Marshal(b, m, deterministic)
}
func (dst *ApplicationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationResponse.Merge(dst, src)
}
func (m *ApplicationResponse) XXX_Size() int {
	return xxx_messageInfo_ApplicationResponse.Size(m)
}
func (m *ApplicationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationResponse proto.InternalMessageInfo

func (m *ApplicationResponse) GetRejected() []*RejectedApplication {
	if m != nil {
		return m.Rejected
	}
	return nil
}

func (m *ApplicationResponse) GetAccepted() []*AcceptedApplication {
	if m != nil {
		return m.Accepted
	}
	return nil
}

func (m *ApplicationResponse) GetUpdated() []*UpdatedApplication {
	if m != nil {
		return m.Updated
	}
	return nil
}

type NodeResponse struct {
	// Rejected Node Registrations
	Rejected []*RejectedNode `protobuf:"bytes,1,rep,name=rejected,proto3" json:"rejected,omitempty"`
	// Accepted Node Registrations
	Accepted             []*AcceptedNode `protobuf:"bytes,2,rep,name=accepted,proto3" json:"accepted,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *NodeResponse) Reset()         { *m = NodeResponse{} }
func (m *NodeResponse) String() string { return proto.CompactTextString(m) }
func (*NodeResponse) ProtoMessage()    {}
func (*NodeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{7}
}
func (m *NodeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeResponse.Unmarshal(m, b)
}
func (m *NodeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeResponse.Marshal(b, m, deterministic)
}
func (dst *NodeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeResponse.Merge(dst, src)
}
func (m *NodeResponse) XXX_Size() int {
	return xxx_messageInfo_NodeResponse.Size(m)
}
func (m *NodeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodeResponse proto.InternalMessageInfo

func (m *NodeResponse) GetRejected() []*RejectedNode {
	if m != nil {
		return m.Rejected
	}
	return nil
}

func (m *NodeResponse) GetAccepted() []*AcceptedNode {
	if m != nil {
		return m.Accepted
	}
	return nil
}

type UpdatedApplication struct {
	// The application ID that was updated
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// State of the application
	State string `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// Timestamp of the state transition
	StateTransitionTimestamp int64 `protobuf:"varint,3,opt,name=stateTransitionTimestamp,proto3" json:"stateTransitionTimestamp,omitempty"`
	// Detailed message
	Message              string   `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdatedApplication) Reset()         { *m = UpdatedApplication{} }
func (m *UpdatedApplication) String() string { return proto.CompactTextString(m) }
func (*UpdatedApplication) ProtoMessage()    {}
func (*UpdatedApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{8}
}
func (m *UpdatedApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdatedApplication.Unmarshal(m, b)
}
func (m *UpdatedApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdatedApplication.Marshal(b, m, deterministic)
}
func (dst *UpdatedApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdatedApplication.Merge(dst, src)
}
func (m *UpdatedApplication) XXX_Size() int {
	return xxx_messageInfo_UpdatedApplication.Size(m)
}
func (m *UpdatedApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdatedApplication.DiscardUnknown(m)
}

var xxx_messageInfo_UpdatedApplication proto.InternalMessageInfo

func (m *UpdatedApplication) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *UpdatedApplication) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *UpdatedApplication) GetStateTransitionTimestamp() int64 {
	if m != nil {
		return m.StateTransitionTimestamp
	}
	return 0
}

func (m *UpdatedApplication) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type RejectedApplication struct {
	// The application ID that was rejected
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// A human-readable reason message
	Reason               string   `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RejectedApplication) Reset()         { *m = RejectedApplication{} }
func (m *RejectedApplication) String() string { return proto.CompactTextString(m) }
func (*RejectedApplication) ProtoMessage()    {}
func (*RejectedApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{9}
}
func (m *RejectedApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RejectedApplication.Unmarshal(m, b)
}
func (m *RejectedApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RejectedApplication.Marshal(b, m, deterministic)
}
func (dst *RejectedApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RejectedApplication.Merge(dst, src)
}
func (m *RejectedApplication) XXX_Size() int {
	return xxx_messageInfo_RejectedApplication.Size(m)
}
func (m *RejectedApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_RejectedApplication.DiscardUnknown(m)
}

var xxx_messageInfo_RejectedApplication proto.InternalMessageInfo

func (m *RejectedApplication) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *RejectedApplication) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type AcceptedApplication struct {
	// The application ID that was accepted
	ApplicationID        string   `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcceptedApplication) Reset()         { *m = AcceptedApplication{} }
func (m *AcceptedApplication) String() string { return proto.CompactTextString(m) }
func (*AcceptedApplication) ProtoMessage()    {}
func (*AcceptedApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{10}
}
func (m *AcceptedApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcceptedApplication.Unmarshal(m, b)
}
func (m *AcceptedApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcceptedApplication.Marshal(b, m, deterministic)
}
func (dst *AcceptedApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcceptedApplication.Merge(dst, src)
}
func (m *AcceptedApplication) XXX_Size() int {
	return xxx_messageInfo_AcceptedApplication.Size(m)
}
func (m *AcceptedApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_AcceptedApplication.DiscardUnknown(m)
}

var xxx_messageInfo_AcceptedApplication proto.InternalMessageInfo

func (m *AcceptedApplication) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

type RejectedNode struct {
	// The node ID that was rejected
	NodeID string `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// A human-readable reason message
	Reason               string   `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RejectedNode) Reset()         { *m = RejectedNode{} }
func (m *RejectedNode) String() string { return proto.CompactTextString(m) }
func (*RejectedNode) ProtoMessage()    {}
func (*RejectedNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{11}
}
func (m *RejectedNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RejectedNode.Unmarshal(m, b)
}
func (m *RejectedNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RejectedNode.Marshal(b, m, deterministic)
}
func (dst *RejectedNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RejectedNode.Merge(dst, src)
}
func (m *RejectedNode) XXX_Size() int {
	return xxx_messageInfo_RejectedNode.Size(m)
}
func (m *RejectedNode) XXX_DiscardUnknown() {
	xxx_messageInfo_RejectedNode.DiscardUnknown(m)
}

var xxx_messageInfo_RejectedNode proto.InternalMessageInfo

func (m *RejectedNode) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *RejectedNode) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type AcceptedNode struct {
	// The node ID that was accepted
	NodeID               string   `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcceptedNode) Reset()         { *m = AcceptedNode{} }
func (m *AcceptedNode) String() string { return proto.CompactTextString(m) }
func (*AcceptedNode) ProtoMessage()    {}
func (*AcceptedNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{12}
}
func (m *AcceptedNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcceptedNode.Unmarshal(m, b)
}
func (m *AcceptedNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcceptedNode.Marshal(b, m, deterministic)
}
func (dst *AcceptedNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcceptedNode.Merge(dst, src)
}
func (m *AcceptedNode) XXX_Size() int {
	return xxx_messageInfo_AcceptedNode.Size(m)
}
func (m *AcceptedNode) XXX_DiscardUnknown() {
	xxx_messageInfo_AcceptedNode.DiscardUnknown(m)
}

var xxx_messageInfo_AcceptedNode proto.InternalMessageInfo

func (m *AcceptedNode) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

type Priority struct {
	// Types that are valid to be assigned to Priority:
	//	*Priority_PriorityValue
	//	*Priority_PriorityClassName
	Priority             isPriority_Priority `protobuf_oneof:"priority"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Priority) Reset()         { *m = Priority{} }
func (m *Priority) String() string { return proto.CompactTextString(m) }
func (*Priority) ProtoMessage()    {}
func (*Priority) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{13}
}
func (m *Priority) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Priority.Unmarshal(m, b)
}
func (m *Priority) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Priority.Marshal(b, m, deterministic)
}
func (dst *Priority) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Priority.Merge(dst, src)
}
func (m *Priority) XXX_Size() int {
	return xxx_messageInfo_Priority.Size(m)
}
func (m *Priority) XXX_DiscardUnknown() {
	xxx_messageInfo_Priority.DiscardUnknown(m)
}

var xxx_messageInfo_Priority proto.InternalMessageInfo

type isPriority_Priority interface {
	isPriority_Priority()
}

type Priority_PriorityValue struct {
	PriorityValue int32 `protobuf:"varint,1,opt,name=priorityValue,proto3,oneof"`
}

type Priority_PriorityClassName struct {
	PriorityClassName string `protobuf:"bytes,2,opt,name=priorityClassName,proto3,oneof"`
}

func (*Priority_PriorityValue) isPriority_Priority() {}

func (*Priority_PriorityClassName) isPriority_Priority() {}

func (m *Priority) GetPriority() isPriority_Priority {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *Priority) GetPriorityValue() int32 {
	if x, ok := m.GetPriority().(*Priority_PriorityValue); ok {
		return x.PriorityValue
	}
	return 0
}

func (m *Priority) GetPriorityClassName() string {
	if x, ok := m.GetPriority().(*Priority_PriorityClassName); ok {
		return x.PriorityClassName
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Priority) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Priority_OneofMarshaler, _Priority_OneofUnmarshaler, _Priority_OneofSizer, []interface{}{
		(*Priority_PriorityValue)(nil),
		(*Priority_PriorityClassName)(nil),
	}
}

func _Priority_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Priority)
	// priority
	switch x := m.Priority.(type) {
	case *Priority_PriorityValue:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.PriorityValue))
	case *Priority_PriorityClassName:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.PriorityClassName)
	case nil:
	default:
		return fmt.Errorf("Priority.Priority has unexpected type %T", x)
	}
	return nil
}

func _Priority_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Priority)
	switch tag {
	case 1: // priority.priorityValue
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Priority = &Priority_PriorityValue{int32(x)}
		return true, err
	case 2: // priority.priorityClassName
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Priority = &Priority_PriorityClassName{x}
		return true, err
	default:
		return false, nil
	}
}

func _Priority_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Priority)
	// priority
	switch x := m.Priority.(type) {
	case *Priority_PriorityValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.PriorityValue))
	case *Priority_PriorityClassName:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.PriorityClassName)))
		n += len(x.PriorityClassName)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A sparse map of resource to Quantity.
type Resource struct {
	Resources            map[string]*Quantity `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Resource) Reset()         { *m = Resource{} }
func (m *Resource) String() string { return proto.CompactTextString(m) }
func (*Resource) ProtoMessage()    {}
func (*Resource) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{14}
}
func (m *Resource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resource.Unmarshal(m, b)
}
func (m *Resource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resource.Marshal(b, m, deterministic)
}
func (dst *Resource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resource.Merge(dst, src)
}
func (m *Resource) XXX_Size() int {
	return xxx_messageInfo_Resource.Size(m)
}
func (m *Resource) XXX_DiscardUnknown() {
	xxx_messageInfo_Resource.DiscardUnknown(m)
}

var xxx_messageInfo_Resource proto.InternalMessageInfo

func (m *Resource) GetResources() map[string]*Quantity {
	if m != nil {
		return m.Resources
	}
	return nil
}

// Quantity includes a single int64 value
type Quantity struct {
	Value                int64    `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Quantity) Reset()         { *m = Quantity{} }
func (m *Quantity) String() string { return proto.CompactTextString(m) }
func (*Quantity) ProtoMessage()    {}
func (*Quantity) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{15}
}
func (m *Quantity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Quantity.Unmarshal(m, b)
}
func (m *Quantity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Quantity.Marshal(b, m, deterministic)
}
func (dst *Quantity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Quantity.Merge(dst, src)
}
func (m *Quantity) XXX_Size() int {
	return xxx_messageInfo_Quantity.Size(m)
}
func (m *Quantity) XXX_DiscardUnknown() {
	xxx_messageInfo_Quantity.DiscardUnknown(m)
}

var xxx_messageInfo_Quantity proto.InternalMessageInfo

func (m *Quantity) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type AllocationAsk struct {
	// Allocation key is used by both of scheduler and RM to track allocations.
	// It doesn't have to be same as RM's internal allocation id (such as Pod name of K8s or ContainerID of YARN).
	// Allocations from the same AllocationAsk which are returned to the RM at the same time will have the same allocationKey.
	// The request is considered an update of the existing AllocationAsk if an ALlocationAsk with the same allocationKey
	// already exists.
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// The application ID this allocation ask belongs to
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The partition the application belongs to
	PartitionName string `protobuf:"bytes,3,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The amount of resources per ask
	ResourceAsk *Resource `protobuf:"bytes,4,opt,name=resourceAsk,proto3" json:"resourceAsk,omitempty"`
	// Maximum number of allocations
	MaxAllocations int32 `protobuf:"varint,5,opt,name=maxAllocations,proto3" json:"maxAllocations,omitempty"`
	// Priority of ask
	Priority *Priority `protobuf:"bytes,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Execution timeout: How long this allocation will be terminated (by scheduler)
	// once allocated by scheduler, 0 or negative value means never expire.
	ExecutionTimeoutMilliSeconds int64 `protobuf:"varint,7,opt,name=executionTimeoutMilliSeconds,proto3" json:"executionTimeoutMilliSeconds,omitempty"`
	// A set of tags for this spscific AllocationAsk. Allocation level tags are used in placing this specific
	// ask on nodes in the cluster. These tags are used in the PlacementConstraints.
	// These tags are optional.
	Tags map[string]string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the TaskGroup this ask belongs to
	TaskGroupName string `protobuf:"bytes,9,opt,name=taskGroupName,proto3" json:"taskGroupName,omitempty"`
	// Is this a placeholder ask (true) or a real ask (false), defaults to false
	// ignored if the taskGroupName is not set
	Placeholder          bool     `protobuf:"varint,10,opt,name=placeholder,proto3" json:"placeholder,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationAsk) Reset()         { *m = AllocationAsk{} }
func (m *AllocationAsk) String() string { return proto.CompactTextString(m) }
func (*AllocationAsk) ProtoMessage()    {}
func (*AllocationAsk) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{16}
}
func (m *AllocationAsk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationAsk.Unmarshal(m, b)
}
func (m *AllocationAsk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationAsk.Marshal(b, m, deterministic)
}
func (dst *AllocationAsk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationAsk.Merge(dst, src)
}
func (m *AllocationAsk) XXX_Size() int {
	return xxx_messageInfo_AllocationAsk.Size(m)
}
func (m *AllocationAsk) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationAsk.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationAsk proto.InternalMessageInfo

func (m *AllocationAsk) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *AllocationAsk) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *AllocationAsk) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *AllocationAsk) GetResourceAsk() *Resource {
	if m != nil {
		return m.ResourceAsk
	}
	return nil
}

func (m *AllocationAsk) GetMaxAllocations() int32 {
	if m != nil {
		return m.MaxAllocations
	}
	return 0
}

func (m *AllocationAsk) GetPriority() *Priority {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *AllocationAsk) GetExecutionTimeoutMilliSeconds() int64 {
	if m != nil {
		return m.ExecutionTimeoutMilliSeconds
	}
	return 0
}

func (m *AllocationAsk) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *AllocationAsk) GetTaskGroupName() string {
	if m != nil {
		return m.TaskGroupName
	}
	return ""
}

func (m *AllocationAsk) GetPlaceholder() bool {
	if m != nil {
		return m.Placeholder
	}
	return false
}

type AddApplicationRequest struct {
	// The ID of the application, must be unique
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The queue this application is requesting. The scheduler will place the application into a
	// queue according to policy, taking into account the requested queue as per the policy.
	QueueName string `protobuf:"bytes,2,opt,name=queueName,proto3" json:"queueName,omitempty"`
	// The partition the application belongs to
	PartitionName string `protobuf:"bytes,3,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The user group information of the application owner
	Ugi *UserGroupInformation `protobuf:"bytes,4,opt,name=ugi,proto3" json:"ugi,omitempty"`
	// A set of tags for the application. These tags provide application level generic inforamtion.
	// The tags are optional and are used in placing an appliction or scheduling.
	// Application tags are not considered when processing AllocationAsks.
	Tags map[string]string `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Execution timeout: How long this application can be in a running state
	// 0 or negative value means never expire.
	ExecutionTimeoutMilliSeconds int64 `protobuf:"varint,6,opt,name=executionTimeoutMilliSeconds,proto3" json:"executionTimeoutMilliSeconds,omitempty"`
	// The total amount of resources gang placeholders will request
	PlaceholderAsk *Resource `protobuf:"bytes,7,opt,name=placeholderAsk,proto3" json:"placeholderAsk,omitempty"`
	// Gang scheduling style can be hard (the application will fail after placeholder timeout)
	// or soft (after the timeout the application will be scheduled as a normal application)
	GangSchedulingStyle  string   `protobuf:"bytes,8,opt,name=gangSchedulingStyle,proto3" json:"gangSchedulingStyle,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddApplicationRequest) Reset()         { *m = AddApplicationRequest{} }
func (m *AddApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*AddApplicationRequest) ProtoMessage()    {}
func (*AddApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{17}
}
func (m *AddApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddApplicationRequest.Unmarshal(m, b)
}
func (m *AddApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddApplicationRequest.Marshal(b, m, deterministic)
}
func (dst *AddApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddApplicationRequest.Merge(dst, src)
}
func (m *AddApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_AddApplicationRequest.Size(m)
}
func (m *AddApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddApplicationRequest proto.InternalMessageInfo

func (m *AddApplicationRequest) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *AddApplicationRequest) GetQueueName() string {
	if m != nil {
		return m.QueueName
	}
	return ""
}

func (m *AddApplicationRequest) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *AddApplicationRequest) GetUgi() *UserGroupInformation {
	if m != nil {
		return m.Ugi
	}
	return nil
}

func (m *AddApplicationRequest) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *AddApplicationRequest) GetExecutionTimeoutMilliSeconds() int64 {
	if m != nil {
		return m.ExecutionTimeoutMilliSeconds
	}
	return 0
}

func (m *AddApplicationRequest) GetPlaceholderAsk() *Resource {
	if m != nil {
		return m.PlaceholderAsk
	}
	return nil
}

func (m *AddApplicationRequest) GetGangSchedulingStyle() string {
	if m != nil {
		return m.GangSchedulingStyle
	}
	return ""
}

type RemoveApplicationRequest struct {
	// The ID of the application to remove
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The partition the application belongs to
	PartitionName        string   `protobuf:"bytes,2,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveApplicationRequest) Reset()         { *m = RemoveApplicationRequest{} }
func (m *RemoveApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveApplicationRequest) ProtoMessage()    {}
func (*RemoveApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{18}
}
func (m *RemoveApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveApplicationRequest.Unmarshal(m, b)
}
func (m *RemoveApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveApplicationRequest.Marshal(b, m, deterministic)
}
func (dst *RemoveApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveApplicationRequest.Merge(dst, src)
}
func (m *RemoveApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveApplicationRequest.Size(m)
}
func (m *RemoveApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveApplicationRequest proto.InternalMessageInfo

func (m *RemoveApplicationRequest) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *RemoveApplicationRequest) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

type UserGroupInformation struct {
	// the user name
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// the list of groups of the user, can be empty
	Groups               []string `protobuf:"bytes,2,rep,name=groups,proto3" json:"groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserGroupInformation) Reset()         { *m = UserGroupInformation{} }
func (m *UserGroupInformation) String() string { return proto.CompactTextString(m) }
func (*UserGroupInformation) ProtoMessage()    {}
func (*UserGroupInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{19}
}
func (m *UserGroupInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserGroupInformation.Unmarshal(m, b)
}
func (m *UserGroupInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserGroupInformation.Marshal(b, m, deterministic)
}
func (dst *UserGroupInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserGroupInformation.Merge(dst, src)
}
func (m *UserGroupInformation) XXX_Size() int {
	return xxx_messageInfo_UserGroupInformation.Size(m)
}
func (m *UserGroupInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_UserGroupInformation.DiscardUnknown(m)
}

var xxx_messageInfo_UserGroupInformation proto.InternalMessageInfo

func (m *UserGroupInformation) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *UserGroupInformation) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

type Allocation struct {
	// AllocationKey from AllocationAsk
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// Allocation tags from AllocationAsk
	AllocationTags map[string]string `protobuf:"bytes,2,rep,name=allocationTags,proto3" json:"allocationTags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// UUID of the allocation
	UUID string `protobuf:"bytes,3,opt,name=UUID,proto3" json:"UUID,omitempty"`
	// Resource for each allocation
	ResourcePerAlloc *Resource `protobuf:"bytes,5,opt,name=resourcePerAlloc,proto3" json:"resourcePerAlloc,omitempty"`
	// Priority of ask
	Priority *Priority `protobuf:"bytes,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Queue which the allocation belongs to
	QueueName string `protobuf:"bytes,7,opt,name=queueName,proto3" json:"queueName,omitempty"`
	// Node which the allocation belongs to
	NodeID string `protobuf:"bytes,8,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// The ID of the application
	ApplicationID string `protobuf:"bytes,9,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// Partition of the allocation
	PartitionName string `protobuf:"bytes,10,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The name of the TaskGroup this allocation belongs to
	TaskGroupName string `protobuf:"bytes,11,opt,name=taskGroupName,proto3" json:"taskGroupName,omitempty"`
	// Is this a placeholder allocation (true) or a real allocation (false), defaults to false
	// ignored if the taskGroupName is not set
	Placeholder          bool     `protobuf:"varint,12,opt,name=placeholder,proto3" json:"placeholder,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Allocation) Reset()         { *m = Allocation{} }
func (m *Allocation) String() string { return proto.CompactTextString(m) }
func (*Allocation) ProtoMessage()    {}
func (*Allocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{20}
}
func (m *Allocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Allocation.Unmarshal(m, b)
}
func (m *Allocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Allocation.Marshal(b, m, deterministic)
}
func (dst *Allocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Allocation.Merge(dst, src)
}
func (m *Allocation) XXX_Size() int {
	return xxx_messageInfo_Allocation.Size(m)
}
func (m *Allocation) XXX_DiscardUnknown() {
	xxx_messageInfo_Allocation.DiscardUnknown(m)
}

var xxx_messageInfo_Allocation proto.InternalMessageInfo

func (m *Allocation) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *Allocation) GetAllocationTags() map[string]string {
	if m != nil {
		return m.AllocationTags
	}
	return nil
}

func (m *Allocation) GetUUID() string {
	if m != nil {
		return m.UUID
	}
	return ""
}

func (m *Allocation) GetResourcePerAlloc() *Resource {
	if m != nil {
		return m.ResourcePerAlloc
	}
	return nil
}

func (m *Allocation) GetPriority() *Priority {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *Allocation) GetQueueName() string {
	if m != nil {
		return m.QueueName
	}
	return ""
}

func (m *Allocation) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *Allocation) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *Allocation) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *Allocation) GetTaskGroupName() string {
	if m != nil {
		return m.TaskGroupName
	}
	return ""
}

func (m *Allocation) GetPlaceholder() bool {
	if m != nil {
		return m.Placeholder
	}
	return false
}

type AllocationReleasesRequest struct {
	// The allocations to release
	AllocationsToRelease []*AllocationRelease `protobuf:"bytes,1,rep,name=allocationsToRelease,proto3" json:"allocationsToRelease,omitempty"`
	// The asks to release
	AllocationAsksToRelease []*AllocationAskRelease `protobuf:"bytes,2,rep,name=allocationAsksToRelease,proto3" json:"allocationAsksToRelease,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                `json:"-"`
	XXX_unrecognized        []byte                  `json:"-"`
	XXX_sizecache           int32                   `json:"-"`
}

func (m *AllocationReleasesRequest) Reset()         { *m = AllocationReleasesRequest{} }
func (m *AllocationReleasesRequest) String() string { return proto.CompactTextString(m) }
func (*AllocationReleasesRequest) ProtoMessage()    {}
func (*AllocationReleasesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{21}
}
func (m *AllocationReleasesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationReleasesRequest.Unmarshal(m, b)
}
func (m *AllocationReleasesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationReleasesRequest.Marshal(b, m, deterministic)
}
func (dst *AllocationReleasesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationReleasesRequest.Merge(dst, src)
}
func (m *AllocationReleasesRequest) XXX_Size() int {
	return xxx_messageInfo_AllocationReleasesRequest.Size(m)
}
func (m *AllocationReleasesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationReleasesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationReleasesRequest proto.InternalMessageInfo

func (m *AllocationReleasesRequest) GetAllocationsToRelease() []*AllocationRelease {
	if m != nil {
		return m.AllocationsToRelease
	}
	return nil
}

func (m *AllocationReleasesRequest) GetAllocationAsksToRelease() []*AllocationAskRelease {
	if m != nil {
		return m.AllocationAsksToRelease
	}
	return nil
}

// Release allocation: this is a bidirectional message. The Terminationtype defines the origin, or creator,
// as per the comment. The confirmation or response from the receiver is the same message with the same
// termination type set.
type AllocationRelease struct {
	// The name of the partition the allocation belongs to
	PartitionName string `protobuf:"bytes,1,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The application the allocation belongs to
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The UUID of the allocation to release, if not set all allocations are released for
	// the applicationID
	UUID string `protobuf:"bytes,3,opt,name=UUID,proto3" json:"UUID,omitempty"`
	// Termination type of the released allocation
	TerminationType TerminationType `protobuf:"varint,4,opt,name=terminationType,proto3,enum=si.v1.TerminationType" json:"terminationType,omitempty"`
	// human-readable message
	Message              string   `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationRelease) Reset()         { *m = AllocationRelease{} }
func (m *AllocationRelease) String() string { return proto.CompactTextString(m) }
func (*AllocationRelease) ProtoMessage()    {}
func (*AllocationRelease) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{22}
}
func (m *AllocationRelease) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationRelease.Unmarshal(m, b)
}
func (m *AllocationRelease) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationRelease.Marshal(b, m, deterministic)
}
func (dst *AllocationRelease) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationRelease.Merge(dst, src)
}
func (m *AllocationRelease) XXX_Size() int {
	return xxx_messageInfo_AllocationRelease.Size(m)
}
func (m *AllocationRelease) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationRelease.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationRelease proto.InternalMessageInfo

func (m *AllocationRelease) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *AllocationRelease) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *AllocationRelease) GetUUID() string {
	if m != nil {
		return m.UUID
	}
	return ""
}

func (m *AllocationRelease) GetTerminationType() TerminationType {
	if m != nil {
		return m.TerminationType
	}
	return TerminationType_UNKNOWN_TERMINATION_TYPE
}

func (m *AllocationRelease) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// Release ask
type AllocationAskRelease struct {
	// Which partition to release the ask from, required.
	PartitionName string `protobuf:"bytes,1,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// optional, when this is set, filter allocation key by application id.
	// when application id is set and allocationKey is not set, release all allocations key under the application id.
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// optional, when this is set, only release allocation ask by specified
	Allocationkey string `protobuf:"bytes,3,opt,name=allocationkey,proto3" json:"allocationkey,omitempty"`
	// Termination type of the released allocation ask
	TerminationType TerminationType `protobuf:"varint,4,opt,name=terminationType,proto3,enum=si.v1.TerminationType" json:"terminationType,omitempty"`
	// For human-readable message
	Message              string   `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationAskRelease) Reset()         { *m = AllocationAskRelease{} }
func (m *AllocationAskRelease) String() string { return proto.CompactTextString(m) }
func (*AllocationAskRelease) ProtoMessage()    {}
func (*AllocationAskRelease) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{23}
}
func (m *AllocationAskRelease) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationAskRelease.Unmarshal(m, b)
}
func (m *AllocationAskRelease) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationAskRelease.Marshal(b, m, deterministic)
}
func (dst *AllocationAskRelease) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationAskRelease.Merge(dst, src)
}
func (m *AllocationAskRelease) XXX_Size() int {
	return xxx_messageInfo_AllocationAskRelease.Size(m)
}
func (m *AllocationAskRelease) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationAskRelease.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationAskRelease proto.InternalMessageInfo

func (m *AllocationAskRelease) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *AllocationAskRelease) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *AllocationAskRelease) GetAllocationkey() string {
	if m != nil {
		return m.Allocationkey
	}
	return ""
}

func (m *AllocationAskRelease) GetTerminationType() TerminationType {
	if m != nil {
		return m.TerminationType
	}
	return TerminationType_UNKNOWN_TERMINATION_TYPE
}

func (m *AllocationAskRelease) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type NodeInfo struct {
	// ID of node, the node must exist to be updated
	NodeID string `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// Action to perform by the scheduler
	Action NodeInfo_ActionFromRM `protobuf:"varint,2,opt,name=action,proto3,enum=si.v1.NodeInfo_ActionFromRM" json:"action,omitempty"`
	// New attributes of node, which will replace previously reported attribute.
	Attributes map[string]string `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// new schedulable resource, scheduler may preempt allocations on the
	// node or schedule more allocations accordingly.
	SchedulableResource *Resource `protobuf:"bytes,4,opt,name=schedulableResource,proto3" json:"schedulableResource,omitempty"`
	// when the scheduler is co-exist with some other schedulers, some node
	// resources might be occupied (allocated) by other schedulers.
	OccupiedResource *Resource `protobuf:"bytes,5,opt,name=occupiedResource,proto3" json:"occupiedResource,omitempty"`
	// Allocated resources, this will be added when node registered to RM (recovery)
	ExistingAllocations  []*Allocation `protobuf:"bytes,6,rep,name=existingAllocations,proto3" json:"existingAllocations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *NodeInfo) Reset()         { *m = NodeInfo{} }
func (m *NodeInfo) String() string { return proto.CompactTextString(m) }
func (*NodeInfo) ProtoMessage()    {}
func (*NodeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{24}
}
func (m *NodeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeInfo.Unmarshal(m, b)
}
func (m *NodeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeInfo.Marshal(b, m, deterministic)
}
func (dst *NodeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeInfo.Merge(dst, src)
}
func (m *NodeInfo) XXX_Size() int {
	return xxx_messageInfo_NodeInfo.Size(m)
}
func (m *NodeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NodeInfo proto.InternalMessageInfo

func (m *NodeInfo) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *NodeInfo) GetAction() NodeInfo_ActionFromRM {
	if m != nil {
		return m.Action
	}
	return NodeInfo_UNKNOWN_ACTION_FROM_RM
}

func (m *NodeInfo) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *NodeInfo) GetSchedulableResource() *Resource {
	if m != nil {
		return m.SchedulableResource
	}
	return nil
}

func (m *NodeInfo) GetOccupiedResource() *Resource {
	if m != nil {
		return m.OccupiedResource
	}
	return nil
}

func (m *NodeInfo) GetExistingAllocations() []*Allocation {
	if m != nil {
		return m.ExistingAllocations
	}
	return nil
}

type RejectedAllocationAsk struct {
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// The ID of the application
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// A human-readable reason message
	Reason               string   `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RejectedAllocationAsk) Reset()         { *m = RejectedAllocationAsk{} }
func (m *RejectedAllocationAsk) String() string { return proto.CompactTextString(m) }
func (*RejectedAllocationAsk) ProtoMessage()    {}
func (*RejectedAllocationAsk) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{25}
}
func (m *RejectedAllocationAsk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RejectedAllocationAsk.Unmarshal(m, b)
}
func (m *RejectedAllocationAsk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RejectedAllocationAsk.Marshal(b, m, deterministic)
}
func (dst *RejectedAllocationAsk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RejectedAllocationAsk.Merge(dst, src)
}
func (m *RejectedAllocationAsk) XXX_Size() int {
	return xxx_messageInfo_RejectedAllocationAsk.Size(m)
}
func (m *RejectedAllocationAsk) XXX_DiscardUnknown() {
	xxx_messageInfo_RejectedAllocationAsk.DiscardUnknown(m)
}

var xxx_messageInfo_RejectedAllocationAsk proto.InternalMessageInfo

func (m *RejectedAllocationAsk) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *RejectedAllocationAsk) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *RejectedAllocationAsk) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type PredicatesArgs struct {
	// allocation key identifies a container, the predicates function is going to check
	// if this container is eligible to be placed ont to a node.
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// the node ID the container is assigned to.
	NodeID string `protobuf:"bytes,2,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// run the predicates for alloactions (true) or reservations (false)
	Allocate             bool     `protobuf:"varint,3,opt,name=allocate,proto3" json:"allocate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PredicatesArgs) Reset()         { *m = PredicatesArgs{} }
func (m *PredicatesArgs) String() string { return proto.CompactTextString(m) }
func (*PredicatesArgs) ProtoMessage()    {}
func (*PredicatesArgs) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{26}
}
func (m *PredicatesArgs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredicatesArgs.Unmarshal(m, b)
}
func (m *PredicatesArgs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredicatesArgs.Marshal(b, m, deterministic)
}
func (dst *PredicatesArgs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredicatesArgs.Merge(dst, src)
}
func (m *PredicatesArgs) XXX_Size() int {
	return xxx_messageInfo_PredicatesArgs.Size(m)
}
func (m *PredicatesArgs) XXX_DiscardUnknown() {
	xxx_messageInfo_PredicatesArgs.DiscardUnknown(m)
}

var xxx_messageInfo_PredicatesArgs proto.InternalMessageInfo

func (m *PredicatesArgs) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *PredicatesArgs) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *PredicatesArgs) GetAllocate() bool {
	if m != nil {
		return m.Allocate
	}
	return false
}

type ReSyncSchedulerCacheArgs struct {
	// a list of assumed allocations, this will be sync'd to scheduler cache.
	AssumedAllocations []*AssumedAllocation `protobuf:"bytes,1,rep,name=assumedAllocations,proto3" json:"assumedAllocations,omitempty"`
	// a list of allocations to forget
	ForgetAllocations    []*ForgotAllocation `protobuf:"bytes,2,rep,name=forgetAllocations,proto3" json:"forgetAllocations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ReSyncSchedulerCacheArgs) Reset()         { *m = ReSyncSchedulerCacheArgs{} }
func (m *ReSyncSchedulerCacheArgs) String() string { return proto.CompactTextString(m) }
func (*ReSyncSchedulerCacheArgs) ProtoMessage()    {}
func (*ReSyncSchedulerCacheArgs) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{27}
}
func (m *ReSyncSchedulerCacheArgs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReSyncSchedulerCacheArgs.Unmarshal(m, b)
}
func (m *ReSyncSchedulerCacheArgs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReSyncSchedulerCacheArgs.Marshal(b, m, deterministic)
}
func (dst *ReSyncSchedulerCacheArgs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReSyncSchedulerCacheArgs.Merge(dst, src)
}
func (m *ReSyncSchedulerCacheArgs) XXX_Size() int {
	return xxx_messageInfo_ReSyncSchedulerCacheArgs.Size(m)
}
func (m *ReSyncSchedulerCacheArgs) XXX_DiscardUnknown() {
	xxx_messageInfo_ReSyncSchedulerCacheArgs.DiscardUnknown(m)
}

var xxx_messageInfo_ReSyncSchedulerCacheArgs proto.InternalMessageInfo

func (m *ReSyncSchedulerCacheArgs) GetAssumedAllocations() []*AssumedAllocation {
	if m != nil {
		return m.AssumedAllocations
	}
	return nil
}

func (m *ReSyncSchedulerCacheArgs) GetForgetAllocations() []*ForgotAllocation {
	if m != nil {
		return m.ForgetAllocations
	}
	return nil
}

type AssumedAllocation struct {
	// allocation key used to identify a container.
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// the node ID the container is assumed to be allocated to, this info is stored in scheduler cache.
	NodeID               string   `protobuf:"bytes,2,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AssumedAllocation) Reset()         { *m = AssumedAllocation{} }
func (m *AssumedAllocation) String() string { return proto.CompactTextString(m) }
func (*AssumedAllocation) ProtoMessage()    {}
func (*AssumedAllocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{28}
}
func (m *AssumedAllocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AssumedAllocation.Unmarshal(m, b)
}
func (m *AssumedAllocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AssumedAllocation.Marshal(b, m, deterministic)
}
func (dst *AssumedAllocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssumedAllocation.Merge(dst, src)
}
func (m *AssumedAllocation) XXX_Size() int {
	return xxx_messageInfo_AssumedAllocation.Size(m)
}
func (m *AssumedAllocation) XXX_DiscardUnknown() {
	xxx_messageInfo_AssumedAllocation.DiscardUnknown(m)
}

var xxx_messageInfo_AssumedAllocation proto.InternalMessageInfo

func (m *AssumedAllocation) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *AssumedAllocation) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

type ForgotAllocation struct {
	// allocation key used to identify a container.
	AllocationKey        string   `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ForgotAllocation) Reset()         { *m = ForgotAllocation{} }
func (m *ForgotAllocation) String() string { return proto.CompactTextString(m) }
func (*ForgotAllocation) ProtoMessage()    {}
func (*ForgotAllocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{29}
}
func (m *ForgotAllocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ForgotAllocation.Unmarshal(m, b)
}
func (m *ForgotAllocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ForgotAllocation.Marshal(b, m, deterministic)
}
func (dst *ForgotAllocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ForgotAllocation.Merge(dst, src)
}
func (m *ForgotAllocation) XXX_Size() int {
	return xxx_messageInfo_ForgotAllocation.Size(m)
}
func (m *ForgotAllocation) XXX_DiscardUnknown() {
	xxx_messageInfo_ForgotAllocation.DiscardUnknown(m)
}

var xxx_messageInfo_ForgotAllocation proto.InternalMessageInfo

func (m *ForgotAllocation) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

type UpdateContainerSchedulingStateRequest struct {
	// application ID
	ApplicartionID string `protobuf:"bytes,1,opt,name=applicartionID,proto3" json:"applicartionID,omitempty"`
	// allocation key used to identify a container.
	AllocationKey string `protobuf:"bytes,2,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// container scheduling state
	State UpdateContainerSchedulingStateRequest_SchedulingState `protobuf:"varint,3,opt,name=state,proto3,enum=si.v1.UpdateContainerSchedulingStateRequest_SchedulingState" json:"state,omitempty"`
	// an optional plain message to explain why it is in such state
	Reason               string   `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateContainerSchedulingStateRequest) Reset()         { *m = UpdateContainerSchedulingStateRequest{} }
func (m *UpdateContainerSchedulingStateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateContainerSchedulingStateRequest) ProtoMessage()    {}
func (*UpdateContainerSchedulingStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{30}
}
func (m *UpdateContainerSchedulingStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateContainerSchedulingStateRequest.Unmarshal(m, b)
}
func (m *UpdateContainerSchedulingStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateContainerSchedulingStateRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateContainerSchedulingStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateContainerSchedulingStateRequest.Merge(dst, src)
}
func (m *UpdateContainerSchedulingStateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateContainerSchedulingStateRequest.Size(m)
}
func (m *UpdateContainerSchedulingStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateContainerSchedulingStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateContainerSchedulingStateRequest proto.InternalMessageInfo

func (m *UpdateContainerSchedulingStateRequest) GetApplicartionID() string {
	if m != nil {
		return m.ApplicartionID
	}
	return ""
}

func (m *UpdateContainerSchedulingStateRequest) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *UpdateContainerSchedulingStateRequest) GetState() UpdateContainerSchedulingStateRequest_SchedulingState {
	if m != nil {
		return m.State
	}
	return UpdateContainerSchedulingStateRequest_UNKNOWN_SCHEDULING_STATE
}

func (m *UpdateContainerSchedulingStateRequest) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type UpdateConfigurationRequest struct {
	// New config what needs to be saved
	Configs              string   `protobuf:"bytes,1,opt,name=configs,proto3" json:"configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateConfigurationRequest) Reset()         { *m = UpdateConfigurationRequest{} }
func (m *UpdateConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConfigurationRequest) ProtoMessage()    {}
func (*UpdateConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{31}
}
func (m *UpdateConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfigurationRequest.Unmarshal(m, b)
}
func (m *UpdateConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfigurationRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfigurationRequest.Merge(dst, src)
}
func (m *UpdateConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConfigurationRequest.Size(m)
}
func (m *UpdateConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfigurationRequest proto.InternalMessageInfo

func (m *UpdateConfigurationRequest) GetConfigs() string {
	if m != nil {
		return m.Configs
	}
	return ""
}

type UpdateConfigurationResponse struct {
	// flag that marks the config update success or failure
	Success bool `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	// the old configuration what was changed
	OldConfig string `protobuf:"bytes,2,opt,name=oldConfig,proto3" json:"oldConfig,omitempty"`
	// reason in case of failure
	Reason               string   `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateConfigurationResponse) Reset()         { *m = UpdateConfigurationResponse{} }
func (m *UpdateConfigurationResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateConfigurationResponse) ProtoMessage()    {}
func (*UpdateConfigurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{32}
}
func (m *UpdateConfigurationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfigurationResponse.Unmarshal(m, b)
}
func (m *UpdateConfigurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfigurationResponse.Marshal(b, m, deterministic)
}
func (dst *UpdateConfigurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfigurationResponse.Merge(dst, src)
}
func (m *UpdateConfigurationResponse) XXX_Size() int {
	return xxx_messageInfo_UpdateConfigurationResponse.Size(m)
}
func (m *UpdateConfigurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfigurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfigurationResponse proto.InternalMessageInfo

func (m *UpdateConfigurationResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *UpdateConfigurationResponse) GetOldConfig() string {
	if m != nil {
		return m.OldConfig
	}
	return ""
}

func (m *UpdateConfigurationResponse) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type EventRecord struct {
	// the type of the object associated with the event
	Type EventRecord_Type `protobuf:"varint,1,opt,name=type,proto3,enum=si.v1.EventRecord_Type" json:"type,omitempty"`
	// ID of the object associated with the event
	ObjectID string `protobuf:"bytes,2,opt,name=objectID,proto3" json:"objectID,omitempty"`
	// the group this object belongs to
	// it specifies the application ID for allocations and the queue for applications
	GroupID string `protobuf:"bytes,3,opt,name=groupID,proto3" json:"groupID,omitempty"`
	// the reason of this event
	Reason string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	// the detailed message as string
	Message string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// timestamp of the event
	TimestampNano        int64    `protobuf:"varint,6,opt,name=timestampNano,proto3" json:"timestampNano,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventRecord) Reset()         { *m = EventRecord{} }
func (m *EventRecord) String() string { return proto.CompactTextString(m) }
func (*EventRecord) ProtoMessage()    {}
func (*EventRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_si_4f9e5b3a38832831, []int{33}
}
func (m *EventRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventRecord.Unmarshal(m, b)
}
func (m *EventRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventRecord.Marshal(b, m, deterministic)
}
func (dst *EventRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventRecord.Merge(dst, src)
}
func (m *EventRecord) XXX_Size() int {
	return xxx_messageInfo_EventRecord.Size(m)
}
func (m *EventRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_EventRecord.DiscardUnknown(m)
}

var xxx_messageInfo_EventRecord proto.InternalMessageInfo

func (m *EventRecord) GetType() EventRecord_Type {
	if m != nil {
		return m.Type
	}
	return EventRecord_UNKNOWN_EVENTRECORD_TYPE
}

func (m *EventRecord) GetObjectID() string {
	if m != nil {
		return m.ObjectID
	}
	return ""
}

func (m *EventRecord) GetGroupID() string {
	if m != nil {
		return m.GroupID
	}
	return ""
}

func (m *EventRecord) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *EventRecord) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *EventRecord) GetTimestampNano() int64 {
	if m != nil {
		return m.TimestampNano
	}
	return 0
}

var E_SiSecret = &proto.ExtensionDesc{
	ExtendedType:  (*descriptorpb.FieldOptions)(nil),
	ExtensionType: (*bool)(nil),
	Field:         1059,
	Name:          "si.v1.si_secret",
	Tag:           "varint,1059,opt,name=si_secret,json=siSecret",
	Filename:      "incubator-yunikorn-scheduler-interface/si.proto",
}

func init() {
	proto.RegisterType((*RegisterResourceManagerRequest)(nil), "si.v1.RegisterResourceManagerRequest")
	proto.RegisterType((*RegisterResourceManagerResponse)(nil), "si.v1.RegisterResourceManagerResponse")
	proto.RegisterType((*AllocationRequest)(nil), "si.v1.AllocationRequest")
	proto.RegisterType((*ApplicationRequest)(nil), "si.v1.ApplicationRequest")
	proto.RegisterType((*NodeRequest)(nil), "si.v1.NodeRequest")
	proto.RegisterType((*AllocationResponse)(nil), "si.v1.AllocationResponse")
	proto.RegisterType((*ApplicationResponse)(nil), "si.v1.ApplicationResponse")
	proto.RegisterType((*NodeResponse)(nil), "si.v1.NodeResponse")
	proto.RegisterType((*UpdatedApplication)(nil), "si.v1.UpdatedApplication")
	proto.RegisterType((*RejectedApplication)(nil), "si.v1.RejectedApplication")
	proto.RegisterType((*AcceptedApplication)(nil), "si.v1.AcceptedApplication")
	proto.RegisterType((*RejectedNode)(nil), "si.v1.RejectedNode")
	proto.RegisterType((*AcceptedNode)(nil), "si.v1.AcceptedNode")
	proto.RegisterType((*Priority)(nil), "si.v1.Priority")
	proto.RegisterType((*Resource)(nil), "si.v1.Resource")
	proto.RegisterMapType((map[string]*Quantity)(nil), "si.v1.Resource.ResourcesEntry")
	proto.RegisterType((*Quantity)(nil), "si.v1.Quantity")
	proto.RegisterType((*AllocationAsk)(nil), "si.v1.AllocationAsk")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.AllocationAsk.TagsEntry")
	proto.RegisterType((*AddApplicationRequest)(nil), "si.v1.AddApplicationRequest")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.AddApplicationRequest.TagsEntry")
	proto.RegisterType((*RemoveApplicationRequest)(nil), "si.v1.RemoveApplicationRequest")
	proto.RegisterType((*UserGroupInformation)(nil), "si.v1.UserGroupInformation")
	proto.RegisterType((*Allocation)(nil), "si.v1.Allocation")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.Allocation.AllocationTagsEntry")
	proto.RegisterType((*AllocationReleasesRequest)(nil), "si.v1.AllocationReleasesRequest")
	proto.RegisterType((*AllocationRelease)(nil), "si.v1.AllocationRelease")
	proto.RegisterType((*AllocationAskRelease)(nil), "si.v1.AllocationAskRelease")
	proto.RegisterType((*NodeInfo)(nil), "si.v1.NodeInfo")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.NodeInfo.AttributesEntry")
	proto.RegisterType((*RejectedAllocationAsk)(nil), "si.v1.RejectedAllocationAsk")
	proto.RegisterType((*PredicatesArgs)(nil), "si.v1.PredicatesArgs")
	proto.RegisterType((*ReSyncSchedulerCacheArgs)(nil), "si.v1.ReSyncSchedulerCacheArgs")
	proto.RegisterType((*AssumedAllocation)(nil), "si.v1.AssumedAllocation")
	proto.RegisterType((*ForgotAllocation)(nil), "si.v1.ForgotAllocation")
	proto.RegisterType((*UpdateContainerSchedulingStateRequest)(nil), "si.v1.UpdateContainerSchedulingStateRequest")
	proto.RegisterType((*UpdateConfigurationRequest)(nil), "si.v1.UpdateConfigurationRequest")
	proto.RegisterType((*UpdateConfigurationResponse)(nil), "si.v1.UpdateConfigurationResponse")
	proto.RegisterType((*EventRecord)(nil), "si.v1.EventRecord")
	proto.RegisterEnum("si.v1.TerminationType", TerminationType_name, TerminationType_value)
	proto.RegisterEnum("si.v1.NodeInfo_ActionFromRM", NodeInfo_ActionFromRM_name, NodeInfo_ActionFromRM_value)
	proto.RegisterEnum("si.v1.UpdateContainerSchedulingStateRequest_SchedulingState", UpdateContainerSchedulingStateRequest_SchedulingState_name, UpdateContainerSchedulingStateRequest_SchedulingState_value)
	proto.RegisterEnum("si.v1.EventRecord_Type", EventRecord_Type_name, EventRecord_Type_value)
	proto.RegisterExtension(E_SiSecret)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SchedulerClient is the client API for Scheduler service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SchedulerClient interface {
	// Register a RM, if it is a reconnect from previous RM the call will
	// trigger a cleanup of all in-memory data and resync with RM.
	RegisterResourceManager(ctx context.Context, in *RegisterResourceManagerRequest, opts ...grpc.CallOption) (*RegisterResourceManagerResponse, error)
	// Update Scheduler status (this includes node status update, allocation request
	// updates, etc. And receive updates from scheduler for allocation changes,
	// any required status changes, etc.
	// Update allocation request
	UpdateAllocation(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateAllocationClient, error)
	// Update application request
	UpdateApplication(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateApplicationClient, error)
	// Update node info
	UpdateNode(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateNodeClient, error)
}

type schedulerClient struct {
	cc *grpc.ClientConn
}

func NewSchedulerClient(cc *grpc.ClientConn) SchedulerClient {
	return &schedulerClient{cc}
}

func (c *schedulerClient) RegisterResourceManager(ctx context.Context, in *RegisterResourceManagerRequest, opts ...grpc.CallOption) (*RegisterResourceManagerResponse, error) {
	out := new(RegisterResourceManagerResponse)
	err := c.cc.Invoke(ctx, "/si.v1.Scheduler/RegisterResourceManager", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *schedulerClient) UpdateAllocation(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateAllocationClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Scheduler_serviceDesc.Streams[0], "/si.v1.Scheduler/UpdateAllocation", opts...)
	if err != nil {
		return nil, err
	}
	x := &schedulerUpdateAllocationClient{stream}
	return x, nil
}

type Scheduler_UpdateAllocationClient interface {
	Send(*AllocationRequest) error
	Recv() (*AllocationResponse, error)
	grpc.ClientStream
}

type schedulerUpdateAllocationClient struct {
	grpc.ClientStream
}

func (x *schedulerUpdateAllocationClient) Send(m *AllocationRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *schedulerUpdateAllocationClient) Recv() (*AllocationResponse, error) {
	m := new(AllocationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *schedulerClient) UpdateApplication(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateApplicationClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Scheduler_serviceDesc.Streams[1], "/si.v1.Scheduler/UpdateApplication", opts...)
	if err != nil {
		return nil, err
	}
	x := &schedulerUpdateApplicationClient{stream}
	return x, nil
}

type Scheduler_UpdateApplicationClient interface {
	Send(*ApplicationRequest) error
	Recv() (*ApplicationResponse, error)
	grpc.ClientStream
}

type schedulerUpdateApplicationClient struct {
	grpc.ClientStream
}

func (x *schedulerUpdateApplicationClient) Send(m *ApplicationRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *schedulerUpdateApplicationClient) Recv() (*ApplicationResponse, error) {
	m := new(ApplicationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *schedulerClient) UpdateNode(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateNodeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Scheduler_serviceDesc.Streams[2], "/si.v1.Scheduler/UpdateNode", opts...)
	if err != nil {
		return nil, err
	}
	x := &schedulerUpdateNodeClient{stream}
	return x, nil
}

type Scheduler_UpdateNodeClient interface {
	Send(*NodeRequest) error
	Recv() (*NodeResponse, error)
	grpc.ClientStream
}

type schedulerUpdateNodeClient struct {
	grpc.ClientStream
}

func (x *schedulerUpdateNodeClient) Send(m *NodeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *schedulerUpdateNodeClient) Recv() (*NodeResponse, error) {
	m := new(NodeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SchedulerServer is the server API for Scheduler service.
type SchedulerServer interface {
	// Register a RM, if it is a reconnect from previous RM the call will
	// trigger a cleanup of all in-memory data and resync with RM.
	RegisterResourceManager(context.Context, *RegisterResourceManagerRequest) (*RegisterResourceManagerResponse, error)
	// Update Scheduler status (this includes node status update, allocation request
	// updates, etc. And receive updates from scheduler for allocation changes,
	// any required status changes, etc.
	// Update allocation request
	UpdateAllocation(Scheduler_UpdateAllocationServer) error
	// Update application request
	UpdateApplication(Scheduler_UpdateApplicationServer) error
	// Update node info
	UpdateNode(Scheduler_UpdateNodeServer) error
}

func RegisterSchedulerServer(s *grpc.Server, srv SchedulerServer) {
	s.RegisterService(&_Scheduler_serviceDesc, srv)
}

func _Scheduler_RegisterResourceManager_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterResourceManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchedulerServer).RegisterResourceManager(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/si.v1.Scheduler/RegisterResourceManager",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchedulerServer).RegisterResourceManager(ctx, req.(*RegisterResourceManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Scheduler_UpdateAllocation_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SchedulerServer).UpdateAllocation(&schedulerUpdateAllocationServer{stream})
}

type Scheduler_UpdateAllocationServer interface {
	Send(*AllocationResponse) error
	Recv() (*AllocationRequest, error)
	grpc.ServerStream
}

type schedulerUpdateAllocationServer struct {
	grpc.ServerStream
}

func (x *schedulerUpdateAllocationServer) Send(m *AllocationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *schedulerUpdateAllocationServer) Recv() (*AllocationRequest, error) {
	m := new(AllocationRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Scheduler_UpdateApplication_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SchedulerServer).UpdateApplication(&schedulerUpdateApplicationServer{stream})
}

type Scheduler_UpdateApplicationServer interface {
	Send(*ApplicationResponse) error
	Recv() (*ApplicationRequest, error)
	grpc.ServerStream
}

type schedulerUpdateApplicationServer struct {
	grpc.ServerStream
}

func (x *schedulerUpdateApplicationServer) Send(m *ApplicationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *schedulerUpdateApplicationServer) Recv() (*ApplicationRequest, error) {
	m := new(ApplicationRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Scheduler_UpdateNode_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SchedulerServer).UpdateNode(&schedulerUpdateNodeServer{stream})
}

type Scheduler_UpdateNodeServer interface {
	Send(*NodeResponse) error
	Recv() (*NodeRequest, error)
	grpc.ServerStream
}

type schedulerUpdateNodeServer struct {
	grpc.ServerStream
}

func (x *schedulerUpdateNodeServer) Send(m *NodeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *schedulerUpdateNodeServer) Recv() (*NodeRequest, error) {
	m := new(NodeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Scheduler_serviceDesc = grpc.ServiceDesc{
	ServiceName: "si.v1.Scheduler",
	HandlerType: (*SchedulerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RegisterResourceManager",
			Handler:    _Scheduler_RegisterResourceManager_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "UpdateAllocation",
			Handler:       _Scheduler_UpdateAllocation_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "UpdateApplication",
			Handler:       _Scheduler_UpdateApplication_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "UpdateNode",
			Handler:       _Scheduler_UpdateNode_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "incubator-yunikorn-scheduler-interface/si.proto",
}

func init() {
	proto.RegisterFile("incubator-yunikorn-scheduler-interface/si.proto", fileDescriptor_si_4f9e5b3a38832831)
}

var fileDescriptor_si_4f9e5b3a38832831 = []byte{
	// 2133 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0x4d, 0x8f, 0xdb, 0xc8,
	0xd1, 0x36, 0x25, 0xcd, 0x8c, 0x54, 0x9a, 0x0f, 0x4d, 0x6b, 0xd6, 0xa6, 0xb5, 0x7e, 0xd7, 0xf3,
	0x32, 0xeb, 0x81, 0x91, 0x85, 0x35, 0xbb, 0xde, 0xc5, 0xda, 0xb0, 0x9d, 0x6c, 0x34, 0x12, 0xbd,
	0x23, 0xd8, 0xfa, 0x70, 0x4b, 0x72, 0xb0, 0xb9, 0x08, 0x1c, 0xaa, 0x47, 0xa6, 0x47, 0x22, 0xb5,
	0x6c, 0x72, 0xe2, 0x41, 0x90, 0x4b, 0x80, 0xdc, 0x02, 0x04, 0x39, 0x05, 0x01, 0x72, 0x0b, 0x90,
	0x4b, 0xfe, 0x41, 0x4e, 0x39, 0xe6, 0x96, 0x4b, 0xf2, 0x0f, 0x72, 0xca, 0xaf, 0x08, 0xba, 0xd9,
	0xcd, 0x0f, 0x91, 0xb2, 0xe5, 0x64, 0x73, 0x63, 0x57, 0x3f, 0x55, 0xdd, 0x5d, 0x55, 0xfd, 0x74,
	0x75, 0x13, 0x8e, 0x2d, 0xdb, 0xf4, 0xcf, 0x0c, 0xcf, 0x71, 0xef, 0x5d, 0xf9, 0xb6, 0x75, 0xe1,
	0xb8, 0xf6, 0x3d, 0x6a, 0xbe, 0x22, 0x13, 0x7f, 0x46, 0xdc, 0x7b, 0x96, 0xed, 0x11, 0xf7, 0xdc,
	0x30, 0xc9, 0x31, 0xb5, 0xea, 0x0b, 0xd7, 0xf1, 0x1c, 0xb4, 0x41, 0xad, 0xfa, 0xe5, 0x67, 0xb5,
	0xc3, 0xa9, 0xe3, 0x4c, 0x67, 0xe4, 0x98, 0x0b, 0xcf, 0xfc, 0xf3, 0xe3, 0x09, 0xa1, 0xa6, 0x6b,
	0x2d, 0x3c, 0xc7, 0x0d, 0x80, 0xda, 0x02, 0x3e, 0xc2, 0x64, 0x6a, 0x51, 0x8f, 0xb8, 0x98, 0x50,
	0xc7, 0x77, 0x4d, 0xd2, 0x31, 0x6c, 0x63, 0xca, 0x9a, 0xdf, 0xfa, 0x84, 0x7a, 0x08, 0x41, 0xc1,
	0x9d, 0xb7, 0x5b, 0xaa, 0x72, 0xa8, 0xdc, 0x2d, 0x61, 0xfe, 0x8d, 0x54, 0xd8, 0xba, 0x24, 0x2e,
	0xb5, 0x1c, 0x5b, 0xcd, 0x71, 0xb1, 0x6c, 0xa2, 0x43, 0x28, 0x2f, 0x9c, 0x99, 0x65, 0x5e, 0x7d,
	0xed, 0x3a, 0xfe, 0x42, 0xcd, 0xf3, 0xde, 0xb8, 0x48, 0xfb, 0x7f, 0xb8, 0xbd, 0x72, 0x44, 0xba,
	0x70, 0x6c, 0x4a, 0xb4, 0x5f, 0x2b, 0xb0, 0xdf, 0x98, 0xcd, 0x1c, 0xd3, 0xf0, 0x2c, 0xc7, 0x96,
	0x13, 0xb9, 0x0b, 0x05, 0x83, 0x5e, 0x50, 0x55, 0x39, 0xcc, 0xdf, 0x2d, 0xdf, 0x3f, 0xa8, 0xf3,
	0x25, 0xd6, 0x23, 0x5c, 0x83, 0x5e, 0x60, 0x8e, 0x40, 0x4f, 0xa0, 0xe8, 0x92, 0x19, 0x31, 0x28,
	0xa1, 0x7c, 0x7e, 0xe5, 0xfb, 0x87, 0x29, 0x34, 0x16, 0x00, 0x61, 0x1d, 0x87, 0x1a, 0xe1, 0x82,
	0xf3, 0xd1, 0x82, 0xb5, 0xdf, 0x28, 0x80, 0x1a, 0x8b, 0xc5, 0xcc, 0x4a, 0x4e, 0xa9, 0x0e, 0x79,
	0x9b, 0xfc, 0x54, 0xcc, 0xe8, 0x96, 0x1c, 0x63, 0x32, 0x49, 0x43, 0x31, 0x03, 0xa2, 0x07, 0xb0,
	0xe9, 0x92, 0xb9, 0x73, 0x49, 0xd4, 0x1c, 0x57, 0xb9, 0x2d, 0x54, 0x30, 0x17, 0x66, 0x68, 0x09,
	0x78, 0xe6, 0x9c, 0x4e, 0xa1, 0xdc, 0x75, 0x26, 0x44, 0xce, 0xe5, 0x0e, 0x6c, 0xd8, 0xce, 0x84,
	0x48, 0xff, 0xec, 0x09, 0xd3, 0x0c, 0xd2, 0xb6, 0xcf, 0x1d, 0x1c, 0xf4, 0x86, 0x96, 0x72, 0x31,
	0x4b, 0xff, 0x62, 0xab, 0x8b, 0x79, 0x26, 0x08, 0x03, 0xfa, 0x5e, 0x7c, 0x75, 0xfb, 0x69, 0x0f,
	0xf2, 0x25, 0x7d, 0x11, 0xfa, 0x7a, 0x22, 0x16, 0xa5, 0xae, 0xf2, 0x75, 0xe8, 0xe3, 0x09, 0xfa,
	0x0a, 0xb6, 0xe5, 0x77, 0x83, 0xc5, 0x34, 0xcf, 0x35, 0x3f, 0xcc, 0x8c, 0xa9, 0x50, 0x4e, 0x28,
	0xa0, 0x87, 0x6c, 0xd8, 0xd7, 0xc4, 0xf4, 0xc8, 0x44, 0x2d, 0x24, 0xdc, 0x8f, 0x85, 0x38, 0x69,
	0x24, 0x44, 0x6b, 0x7f, 0x56, 0xa0, 0x9a, 0xf0, 0xb4, 0x58, 0xed, 0x97, 0x31, 0x8b, 0xc1, 0x92,
	0x6b, 0xcb, 0x16, 0x63, 0x5a, 0x21, 0x96, 0xe9, 0x19, 0xa6, 0x49, 0x16, 0x5e, 0xe8, 0x00, 0xa9,
	0xd7, 0x10, 0xe2, 0x84, 0x9e, 0xc4, 0xa2, 0xcf, 0x61, 0xcb, 0x5f, 0x4c, 0x0c, 0xa6, 0x16, 0xac,
	0xfe, 0xa6, 0x50, 0x1b, 0x05, 0xd2, 0xb8, 0x96, 0x44, 0x6a, 0x0b, 0xd8, 0x0e, 0x62, 0x2e, 0x26,
	0x7d, 0x9c, 0x9a, 0x74, 0x75, 0x69, 0xd2, 0x1c, 0x1e, 0xcd, 0xf6, 0x38, 0x35, 0xdb, 0xea, 0xd2,
	0x6c, 0x03, 0x05, 0x09, 0xd2, 0xfe, 0xa8, 0x00, 0x4a, 0xcf, 0x08, 0x7d, 0x0c, 0x3b, 0x46, 0xd4,
	0x0c, 0xe9, 0x21, 0x29, 0x44, 0x07, 0xb0, 0x41, 0x3d, 0xc3, 0x23, 0x22, 0xdb, 0x82, 0x06, 0x7a,
	0x04, 0x2a, 0xff, 0x18, 0xba, 0x86, 0x4d, 0x2d, 0x06, 0x1d, 0x5a, 0x73, 0x42, 0x3d, 0x63, 0x1e,
	0x10, 0x46, 0x1e, 0xaf, 0xec, 0x67, 0xcc, 0x33, 0x27, 0x94, 0x1a, 0x53, 0xa2, 0x16, 0x02, 0xe6,
	0x11, 0x4d, 0x6d, 0x00, 0xd5, 0x8c, 0x40, 0xad, 0x39, 0xd1, 0xeb, 0x6c, 0x63, 0x1a, 0x34, 0xe4,
	0x33, 0xd1, 0xd2, 0x1e, 0x43, 0x35, 0x23, 0x8a, 0xeb, 0x19, 0xd5, 0x7e, 0x08, 0xdb, 0xf1, 0x28,
	0xb0, 0x41, 0xd8, 0x1e, 0x0c, 0xe1, 0xa2, 0xb5, 0x72, 0xf0, 0x23, 0xd8, 0x8e, 0x07, 0x65, 0x95,
	0xbe, 0x66, 0x43, 0xb1, 0xef, 0x5a, 0x8e, 0x6b, 0x79, 0x57, 0xe8, 0x08, 0x76, 0x16, 0xe2, 0xfb,
	0xa5, 0x31, 0xf3, 0x09, 0x87, 0x6e, 0x9c, 0x5e, 0xc3, 0x49, 0x31, 0xaa, 0xc3, 0xbe, 0x14, 0x34,
	0x67, 0x06, 0xa5, 0x5d, 0x63, 0x2e, 0xa2, 0x74, 0x7a, 0x0d, 0xa7, 0xbb, 0x4e, 0x00, 0x8a, 0x52,
	0xa8, 0xfd, 0x56, 0x81, 0xa2, 0xa4, 0x6e, 0xf4, 0x04, 0x4a, 0xae, 0xf8, 0x96, 0xd4, 0xf3, 0x51,
	0x98, 0x82, 0x81, 0x3c, 0xfc, 0xa0, 0xba, 0xed, 0xb9, 0x57, 0x38, 0x52, 0xa8, 0x75, 0x60, 0x37,
	0xd9, 0x89, 0x2a, 0x90, 0xbf, 0x20, 0x57, 0x62, 0x85, 0xec, 0x93, 0x11, 0xdb, 0x25, 0x5f, 0x4a,
	0x40, 0xe5, 0x92, 0xd8, 0x5e, 0xf8, 0x86, 0xed, 0x59, 0xde, 0x15, 0x0e, 0x7a, 0x1f, 0xe5, 0x1e,
	0x2a, 0xda, 0x21, 0x14, 0xa5, 0x98, 0xe5, 0xde, 0x65, 0xe8, 0x81, 0xbc, 0x40, 0x69, 0xbf, 0x28,
	0xc0, 0x4e, 0x82, 0x19, 0x78, 0x2c, 0x43, 0xc1, 0xb3, 0x70, 0xe8, 0xa4, 0x30, 0x1d, 0xf1, 0x5c,
	0x56, 0x1a, 0x7d, 0x0c, 0x3b, 0x0b, 0xc3, 0xf5, 0x78, 0xce, 0x72, 0x8f, 0x06, 0x7c, 0x9d, 0x14,
	0xa2, 0xcf, 0xa0, 0x2c, 0x3d, 0xd0, 0xa0, 0x17, 0x3c, 0x8f, 0xa3, 0x65, 0x49, 0x77, 0xe0, 0x38,
	0x06, 0x1d, 0xc1, 0xee, 0xdc, 0x78, 0x13, 0x4d, 0x9c, 0xaa, 0x1b, 0x2c, 0xae, 0x78, 0x49, 0x8a,
	0x3e, 0x89, 0xc2, 0xa4, 0x6e, 0x26, 0xec, 0xca, 0x0c, 0xc1, 0x21, 0x00, 0x9d, 0xc0, 0x2d, 0xf2,
	0x86, 0x98, 0xbe, 0xdc, 0x61, 0x8e, 0xef, 0x75, 0xac, 0xd9, 0xcc, 0x1a, 0x10, 0xd3, 0xb1, 0x27,
	0x54, 0xdd, 0xe2, 0x8e, 0x7b, 0x2b, 0x06, 0xdd, 0x87, 0x82, 0x67, 0x4c, 0xa9, 0x5a, 0x4c, 0x44,
	0x3e, 0xe1, 0xe1, 0xfa, 0xd0, 0x98, 0x8a, 0xc8, 0x73, 0x2c, 0xf3, 0x92, 0x67, 0xd0, 0x0b, 0x5e,
	0x0e, 0x70, 0x2f, 0x95, 0x02, 0x2f, 0x25, 0x84, 0xbc, 0x92, 0x98, 0x19, 0x26, 0x79, 0xe5, 0xcc,
	0x26, 0xc4, 0x55, 0xe1, 0x50, 0xb9, 0x5b, 0xc4, 0x71, 0x51, 0xed, 0x01, 0x94, 0x42, 0xd3, 0x19,
	0x79, 0x73, 0x10, 0xcf, 0x9b, 0x52, 0x3c, 0x4d, 0xfe, 0x9e, 0x87, 0x0f, 0x32, 0x4f, 0xe9, 0x35,
	0xd9, 0xe2, 0x16, 0x94, 0xbe, 0xf5, 0x89, 0x4f, 0xa2, 0x4d, 0x83, 0x23, 0xc1, 0x9a, 0x49, 0x70,
	0x0f, 0xf2, 0xfe, 0xd4, 0x12, 0xc1, 0x97, 0x07, 0xdf, 0x88, 0x12, 0x97, 0x7b, 0x80, 0x9d, 0xd8,
	0xee, 0x5c, 0x1c, 0xb3, 0xfe, 0xd4, 0x42, 0x8f, 0x84, 0x9f, 0x37, 0xb8, 0x9f, 0x8f, 0xde, 0x56,
	0x6a, 0xa4, 0xfc, 0xfd, 0xae, 0x38, 0x6f, 0xae, 0x11, 0xe7, 0x07, 0xb0, 0x1b, 0x73, 0x3d, 0x4b,
	0xdb, 0xad, 0xec, 0xb4, 0x5d, 0x82, 0xa1, 0x4f, 0xa1, 0x3a, 0x35, 0xec, 0xe9, 0x20, 0xa8, 0x56,
	0x2d, 0x7b, 0x3a, 0xf0, 0xae, 0x66, 0x44, 0x2d, 0x72, 0x9f, 0x64, 0x75, 0xfd, 0xe7, 0x61, 0x3d,
	0x07, 0x75, 0x55, 0x21, 0xb5, 0x66, 0x60, 0x53, 0xa1, 0xcb, 0x65, 0x84, 0x4e, 0x3b, 0x81, 0x83,
	0xac, 0x40, 0xb1, 0xd2, 0xca, 0xa7, 0xc4, 0x95, 0x95, 0x32, 0xfb, 0x66, 0x9c, 0x3d, 0x65, 0x38,
	0xca, 0x4f, 0xdb, 0x12, 0x16, 0x2d, 0xed, 0x57, 0x05, 0x80, 0x68, 0x97, 0xac, 0x49, 0x42, 0x1d,
	0xd8, 0x8d, 0x04, 0xcc, 0x47, 0xe2, 0x08, 0xbf, 0x93, 0xda, 0x76, 0xb1, 0xcf, 0x28, 0x1b, 0x96,
	0x94, 0xd9, 0x7c, 0x47, 0xa3, 0xa8, 0xa8, 0x64, 0xdf, 0xe8, 0x31, 0x54, 0x24, 0xef, 0xf4, 0x89,
	0xcb, 0xad, 0x70, 0xaa, 0xc9, 0x88, 0x74, 0x0a, 0xf8, 0x7e, 0xec, 0x93, 0xd8, 0x44, 0x5b, 0xcb,
	0x9b, 0x28, 0x3a, 0xeb, 0x8a, 0x89, 0xb3, 0x32, 0x15, 0xc7, 0xd2, 0x5a, 0x71, 0x84, 0xac, 0x2d,
	0x98, 0xe2, 0xa1, 0xf2, 0x1a, 0x3c, 0xb4, 0x9d, 0xe6, 0xa1, 0x06, 0x54, 0x33, 0xdc, 0xfd, 0x5e,
	0xa9, 0xfb, 0x17, 0x05, 0x6e, 0xae, 0xbc, 0x9b, 0xa0, 0xe7, 0x70, 0x10, 0x85, 0x8e, 0x0e, 0x1d,
	0xd1, 0x2f, 0x8e, 0xdb, 0xd5, 0xf5, 0x76, 0xa6, 0x16, 0x1a, 0xc1, 0x0d, 0x23, 0xce, 0xcf, 0x31,
	0x83, 0xb9, 0x77, 0x97, 0xe1, 0xab, 0x74, 0xb5, 0xbf, 0x2d, 0x5d, 0xda, 0x82, 0xc1, 0x52, 0x91,
	0x50, 0x56, 0x44, 0x62, 0x8d, 0xd3, 0x35, 0x2b, 0x5f, 0x7f, 0x04, 0x7b, 0x1e, 0x71, 0xe7, 0x96,
	0x1d, 0x38, 0xff, 0x6a, 0x11, 0xd4, 0x85, 0xbb, 0xf7, 0xaf, 0x8b, 0x45, 0x0c, 0x93, 0xbd, 0x78,
	0x19, 0x1e, 0xaf, 0x28, 0x37, 0x92, 0x15, 0xe5, 0x3f, 0x15, 0x38, 0xc8, 0xf2, 0xc1, 0x77, 0xba,
	0xa8, 0xc4, 0xce, 0x67, 0xf9, 0x92, 0x5f, 0xde, 0xf9, 0x2c, 0x73, 0xfe, 0x97, 0xcb, 0xfc, 0x7d,
	0x01, 0x8a, 0xf2, 0x96, 0xb8, 0xb2, 0x46, 0xfd, 0x02, 0x36, 0x0d, 0xd3, 0x93, 0x17, 0xfe, 0xdd,
	0xf0, 0xb6, 0x25, 0x15, 0xeb, 0x0d, 0xde, 0xfb, 0xd4, 0x75, 0xe6, 0xb8, 0x83, 0x05, 0x16, 0x7d,
	0x05, 0x60, 0x78, 0x9e, 0x6b, 0x9d, 0xf9, 0x1e, 0x91, 0x97, 0xbc, 0xdb, 0x29, 0xcd, 0x10, 0x11,
	0xd0, 0x54, 0x4c, 0x05, 0x35, 0xa0, 0x2a, 0xde, 0x39, 0x8c, 0xb3, 0x19, 0x91, 0xd4, 0xb3, 0xaa,
	0x64, 0xca, 0xc2, 0x32, 0x46, 0x73, 0x4c, 0xd3, 0x5f, 0x58, 0x64, 0x12, 0xea, 0xaf, 0x62, 0xb4,
	0x65, 0x20, 0x6a, 0x42, 0x95, 0xbc, 0xb1, 0xa8, 0x67, 0xd9, 0xd3, 0x78, 0xf1, 0xb5, 0xb9, 0xea,
	0x4a, 0x9c, 0x85, 0xae, 0xfd, 0x00, 0xf6, 0x96, 0xd6, 0xf8, 0x5e, 0xdc, 0xf0, 0x73, 0x76, 0x0d,
	0x88, 0x9c, 0x8b, 0x6a, 0x70, 0x7d, 0xd4, 0x7d, 0xd6, 0xed, 0xfd, 0xb8, 0x3b, 0x6e, 0x34, 0x87,
	0xed, 0x5e, 0x77, 0xfc, 0x14, 0xf7, 0x3a, 0x63, 0xdc, 0xa9, 0x5c, 0x43, 0x00, 0x9b, 0x4d, 0xac,
	0x37, 0x86, 0x7a, 0x45, 0x61, 0xdf, 0xa3, 0x7e, 0x8b, 0x7d, 0xe7, 0xd0, 0x2e, 0x40, 0x0b, 0x37,
	0xda, 0xdd, 0x71, 0xb7, 0xd7, 0xd2, 0x2b, 0x79, 0xb4, 0x07, 0xe5, 0x96, 0xde, 0xec, 0x75, 0xda,
	0x83, 0x41, 0xbb, 0xd7, 0xad, 0x14, 0x90, 0x0a, 0x07, 0x01, 0x60, 0xd8, 0x1b, 0x0f, 0x9a, 0xa7,
	0x7a, 0x6b, 0xf4, 0xbc, 0x71, 0xf2, 0x5c, 0xaf, 0x6c, 0x68, 0x3f, 0x83, 0x0f, 0x32, 0xaf, 0xd4,
	0xdf, 0x69, 0xe1, 0x1c, 0x5d, 0x81, 0xf2, 0x89, 0x2b, 0xd0, 0x6b, 0xd8, 0xed, 0xbb, 0x64, 0xc2,
	0x80, 0x84, 0x36, 0xdc, 0xa0, 0x78, 0x5c, 0x63, 0xd4, 0x28, 0x8d, 0x73, 0x89, 0x34, 0xae, 0x41,
	0x51, 0x00, 0x83, 0xb2, 0xac, 0x88, 0xc3, 0xb6, 0xf6, 0x27, 0x85, 0xd5, 0x0f, 0x83, 0x2b, 0xdb,
	0x1c, 0xc8, 0xa7, 0xb5, 0xa6, 0x61, 0xbe, 0x22, 0x7c, 0xd8, 0x53, 0x40, 0x06, 0xa5, 0xfe, 0x3c,
	0xee, 0x04, 0xba, 0x4c, 0xc0, 0xcb, 0x00, 0x9c, 0xa1, 0x83, 0x74, 0xd8, 0x3f, 0x77, 0xdc, 0x29,
	0xf1, 0xe2, 0x86, 0x02, 0xe2, 0xbd, 0x21, 0x0c, 0x3d, 0x75, 0xdc, 0xa9, 0x13, 0xeb, 0xc7, 0x69,
	0x0d, 0xed, 0x05, 0xec, 0xa7, 0xc6, 0xfb, 0xef, 0x9c, 0xa3, 0x3d, 0x84, 0xca, 0xf2, 0xc8, 0xeb,
	0x59, 0xd4, 0xfe, 0x9a, 0x83, 0x3b, 0xc1, 0x23, 0x41, 0xd3, 0xb1, 0x3d, 0xc3, 0xb2, 0x89, 0x1b,
	0xaf, 0xea, 0x0c, 0x2f, 0x7c, 0xa5, 0x3a, 0x82, 0x5d, 0x11, 0x79, 0x37, 0x51, 0x88, 0x2d, 0x49,
	0xd3, 0xe3, 0xe6, 0xb2, 0x56, 0x82, 0xe5, 0xfb, 0x42, 0x9e, 0x93, 0xd2, 0x93, 0xc4, 0x0b, 0xca,
	0x3b, 0xa6, 0x52, 0x5f, 0x16, 0x8b, 0xd7, 0x89, 0x28, 0x15, 0x0b, 0x89, 0x54, 0x24, 0xb0, 0xb7,
	0xa4, 0x81, 0x6e, 0x81, 0x2a, 0x77, 0xa2, 0xd8, 0x33, 0xed, 0xee, 0xd7, 0xe3, 0xc1, 0x90, 0xed,
	0xb9, 0x6b, 0xa8, 0x0c, 0x5b, 0x83, 0x67, 0xed, 0x7e, 0x5f, 0x6f, 0x55, 0x14, 0xb4, 0x03, 0x25,
	0x01, 0xd1, 0x5b, 0x95, 0x1c, 0xda, 0x86, 0x22, 0xd6, 0x07, 0x3a, 0x7e, 0xa9, 0xb7, 0x2a, 0x79,
	0xb6, 0x53, 0x9f, 0x36, 0xda, 0xac, 0xa7, 0xa0, 0x7d, 0x09, 0xb5, 0x70, 0xfa, 0xe7, 0xd6, 0xd4,
	0x77, 0x13, 0x65, 0xac, 0x0a, 0x5b, 0x26, 0x97, 0x53, 0xe1, 0x37, 0xd9, 0xd4, 0xe6, 0xf0, 0x61,
	0xa6, 0x9e, 0x78, 0x28, 0x52, 0x61, 0x8b, 0xfa, 0xa6, 0x49, 0x68, 0xa0, 0x58, 0xc4, 0xb2, 0xc9,
	0xea, 0x30, 0x67, 0x36, 0x09, 0xb4, 0xe4, 0x65, 0x26, 0x14, 0xac, 0xdc, 0x98, 0xbf, 0xcb, 0x41,
	0x59, 0xbf, 0x24, 0xb6, 0x87, 0x89, 0xe9, 0xb8, 0x13, 0xf4, 0x09, 0x14, 0x3c, 0x76, 0x2a, 0x29,
	0x3c, 0x10, 0x32, 0x91, 0x63, 0x88, 0x3a, 0x3f, 0x96, 0x38, 0x88, 0xed, 0x42, 0xe7, 0x8c, 0x51,
	0x4a, 0x98, 0x82, 0x61, 0x9b, 0x4d, 0x94, 0x97, 0xc8, 0xe1, 0x39, 0x2f, 0x9b, 0xab, 0x02, 0xb3,
	0xfa, 0x64, 0xe3, 0x05, 0x9e, 0x7c, 0x39, 0xea, 0x1a, 0xb6, 0x23, 0x6e, 0x3a, 0x49, 0xa1, 0xd6,
	0x83, 0x02, 0x3f, 0x21, 0x63, 0xd1, 0xd4, 0x5f, 0xea, 0xdd, 0x21, 0xd6, 0x9b, 0x3d, 0xdc, 0x1a,
	0x0f, 0xbf, 0xe9, 0x8b, 0x68, 0x62, 0xfd, 0xc5, 0x48, 0x1f, 0x0c, 0x2b, 0x0a, 0xda, 0x82, 0x7c,
	0xa3, 0xdf, 0xaf, 0xe4, 0x50, 0x11, 0x0a, 0x82, 0x51, 0x4b, 0xb0, 0xf1, 0x62, 0xa4, 0x8f, 0xf4,
	0x4a, 0xe1, 0xfb, 0xbf, 0x54, 0x60, 0x6f, 0xe9, 0x3c, 0x8e, 0x1b, 0x1f, 0xea, 0xb8, 0xd3, 0xee,
	0x36, 0x38, 0x73, 0x0b, 0xe3, 0xfb, 0xb0, 0x33, 0x18, 0xf6, 0x58, 0xaa, 0x8c, 0x4f, 0xbe, 0x61,
	0x4c, 0xae, 0xb0, 0xf1, 0x86, 0xed, 0x8e, 0xde, 0x1b, 0x0d, 0x2b, 0x39, 0x46, 0xf9, 0x7d, 0xac,
	0xeb, 0x9d, 0xfe, 0x30, 0x40, 0xc8, 0x54, 0xc2, 0x95, 0x3c, 0x63, 0xee, 0xfe, 0xf3, 0x46, 0x53,
	0x3f, 0xed, 0x3d, 0x6f, 0xe9, 0x78, 0x8c, 0x75, 0xde, 0x6a, 0x55, 0x0a, 0xf7, 0xff, 0x91, 0x83,
	0x52, 0x48, 0x65, 0xe8, 0x35, 0xdc, 0x58, 0xf1, 0xee, 0x8e, 0xee, 0x84, 0x07, 0xe1, 0xdb, 0xfe,
	0x04, 0xd4, 0x8e, 0xde, 0x05, 0x13, 0xcf, 0xf7, 0xd7, 0x50, 0x07, 0x2a, 0x41, 0x32, 0xc6, 0x98,
	0x24, 0xab, 0x4c, 0x0d, 0xec, 0xde, 0xcc, 0xe8, 0x91, 0xa6, 0xee, 0x2a, 0x9f, 0x2a, 0xa8, 0x0f,
	0xfb, 0xc2, 0x5c, 0xec, 0x0d, 0x2e, 0xd4, 0x4a, 0x5d, 0xf6, 0x6a, 0xb5, 0xac, 0xae, 0x84, 0xc5,
	0xc7, 0x00, 0x81, 0x45, 0xfe, 0xb0, 0x86, 0x62, 0x25, 0x89, 0xb4, 0x51, 0x4d, 0xc8, 0xe2, 0xca,
	0x8f, 0x1e, 0x43, 0x89, 0x5a, 0x63, 0x4a, 0x4c, 0x97, 0x78, 0xe8, 0xff, 0xea, 0xc1, 0x3f, 0x96,
	0xba, 0xfc, 0xc7, 0x52, 0x7f, 0x6a, 0x91, 0xd9, 0xa4, 0xb7, 0x08, 0x88, 0xfd, 0x0f, 0xc5, 0xe0,
	0x94, 0xa1, 0xec, 0x26, 0xed, 0x12, 0xef, 0xa4, 0xfc, 0x93, 0xd2, 0xcc, 0x3a, 0x3b, 0x9e, 0x3a,
	0xc7, 0xd4, 0x3a, 0xdb, 0xe4, 0x4a, 0x9f, 0xff, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x39, 0xca, 0xd6,
	0x08, 0xe0, 0x19, 0x00, 0x00,
}
