/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.exec.TimeoutObserver;

public class Watchdog
implements Runnable {
    private final Vector<TimeoutObserver> observers = new Vector(1);
    private final long timeout;
    private boolean stopped = false;

    public Watchdog(long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout must not be less than 1.");
        }
        this.timeout = timeout;
    }

    public void addTimeoutObserver(TimeoutObserver to2) {
        this.observers.addElement(to2);
    }

    public void removeTimeoutObserver(TimeoutObserver to2) {
        this.observers.removeElement(to2);
    }

    protected final void fireTimeoutOccured() {
        Enumeration<TimeoutObserver> e = this.observers.elements();
        while (e.hasMoreElements()) {
            e.nextElement().timeoutOccured(this);
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "WATCHDOG");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean isWaiting;
        long startTime = System.currentTimeMillis();
        Watchdog watchdog = this;
        synchronized (watchdog) {
            long timeLeft = this.timeout - (System.currentTimeMillis() - startTime);
            boolean bl = isWaiting = timeLeft > 0L;
            while (!this.stopped && isWaiting) {
                try {
                    this.wait(timeLeft);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                timeLeft = this.timeout - (System.currentTimeMillis() - startTime);
                isWaiting = timeLeft > 0L;
            }
        }
        if (!isWaiting) {
            this.fireTimeoutOccured();
        }
    }
}

