/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Forever$;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsSettings$;
import akka.io.dns.internal.ResolvConf;
import akka.io.dns.internal.ResolvConfParser$;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import akka.util.ccompat.package$;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.net.InetSocketAddress;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005-e!B\u0001\u0003\u0005\tA!a\u0003#ogN+G\u000f^5oONT!a\u0001\u0003\u0002\u0007\u0011t7O\u0003\u0002\u0006\r\u0005\u0011\u0011n\u001c\u0006\u0002\u000f\u0005!\u0011m[6b'\t\u0001\u0011\u0002\u0005\u0002\u000b\u001b5\t1BC\u0001\r\u0003\u0015\u00198-\u00197b\u0013\tq1B\u0001\u0004B]f\u0014VM\u001a\u0005\t!\u0001\u0011\t\u0011)A\u0005%\u000511/_:uK6\u001c\u0001\u0001\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005)\u0011m\u0019;pe&\u0011q\u0003\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005\t1\r\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u000511m\u001c8gS\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005\u0019\u0019uN\u001c4jO\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"2aJ\u0015+!\tA\u0003!D\u0001\u0003\u0011\u0015\u0001B\u00051\u0001\u0013\u0011\u0015IB\u00051\u0001\u001b\u0011\u001da\u0003A1A\u0005\u00025\n1BT1nKN+'O^3sgV\ta\u0006E\u00020oir!\u0001M\u001b\u000f\u0005E\"T\"\u0001\u001a\u000b\u0005M\n\u0012A\u0002\u001fs_>$h(C\u0001\r\u0013\t14\"A\u0004qC\u000e\\\u0017mZ3\n\u0005aJ$\u0001\u0002'jgRT!AN\u0006\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014a\u00018fi*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u0018\u0002\u00199\u000bW.Z*feZ,'o\u001d\u0011\t\u000f\u0015\u0003!\u0019!C\u0001\r\u0006q!+Z:pYZ,G+[7f_V$X#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u00051[\u0011AC2p]\u000e,(O]3oi&\u0011a*\u0013\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011\u0019\u0001\u0006\u0001)A\u0005\u000f\u0006y!+Z:pYZ,G+[7f_V$\b\u0005C\u0004S\u0001\t\u0007I\u0011A*\u0002'A{7/\u001b;jm\u0016\u001c\u0015m\u00195f!>d\u0017nY=\u0016\u0003Q\u0003\"!\u00160\u000f\u0005YcfBA,\\\u001d\tA&L\u0004\u000223&\tq!\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003;\n\t1bQ1dQ\u0016\u0004v\u000e\\5ds&\u0011q\f\u0019\u0002\f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u0017P\u0003\u0002^\u0005!1!\r\u0001Q\u0001\nQ\u000bA\u0003U8tSRLg/Z\"bG\",\u0007k\u001c7jGf\u0004\u0003b\u00023\u0001\u0005\u0004%\taU\u0001\u0014\u001d\u0016<\u0017\r^5wK\u000e\u000b7\r[3Q_2L7-\u001f\u0005\u0007M\u0002\u0001\u000b\u0011\u0002+\u0002)9+w-\u0019;jm\u0016\u001c\u0015m\u00195f!>d\u0017nY=!\u0011\u0015A\u0007\u0001\"\u0003j\u0003\u00199W\r\u001e+uYR\u0011AK\u001b\u0005\u0006W\u001e\u0004\r\u0001\\\u0001\u0005a\u0006$\b\u000e\u0005\u0002na:\u0011!B\\\u0005\u0003_.\ta\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011qn\u0003\u0005\ti\u0002A)\u0019!C\u0005k\u0006Q!/Z:pYZ\u001cuN\u001c4\u0016\u0003Y\u00042AC<z\u0013\tA8B\u0001\u0004PaRLwN\u001c\t\u0003uvl\u0011a\u001f\u0006\u0003y\n\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003}n\u0014!BU3t_248i\u001c8g\u0011%\t\t\u0001\u0001E\u0001B\u0003&a/A\u0006sKN|GN^\"p]\u001a\u0004\u0003\"CA\u0003\u0001\t\u0007I\u0011AA\u0004\u00035\u0019V-\u0019:dQ\u0012{W.Y5ogV\u0011\u0011\u0011\u0002\t\u0004_]b\u0007\u0002CA\u0007\u0001\u0001\u0006I!!\u0003\u0002\u001dM+\u0017M]2i\t>l\u0017-\u001b8tA!I\u0011\u0011\u0003\u0001C\u0002\u0013\u0005\u00111C\u0001\u0006\u001d\u0012{Go]\u000b\u0003\u0003+\u00012ACA\f\u0013\r\tIb\u0003\u0002\u0004\u0013:$\b\u0002CA\u000f\u0001\u0001\u0006I!!\u0006\u0002\r9#u\u000e^:!\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tqEZ1jYVs\u0017M\u00197f)>$U\r^3s[&tW\rR3gCVdGOT1nKN,'O^3sgV\u0011\u0011Q\u0005\t\u0004\u0015\u0005\u001d\u0012bAA\u0015\u0017\t9aj\u001c;iS:<\u0007f\u0001\u0001\u0002.A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9$!\r\u0003\u0017%sG/\u001a:oC2\f\u0005/[\u0004\b\u0003w\u0011\u0001\u0012AA\u001f\u0003-!en]*fiRLgnZ:\u0011\u0007!\nyD\u0002\u0004\u0002\u0005!\u0005\u0011\u0011I\n\u0004\u0003\u007fI\u0001bB\u0013\u0002@\u0011\u0005\u0011Q\t\u000b\u0003\u0003{A!\"!\u0013\u0002@\t\u0007IQBA&\u0003=!en\u001d$bY2\u0014\u0017mY6Q_J$XCAA'\u001f\t\ty%H\u00016\u0011%\t\u0019&a\u0010!\u0002\u001b\ti%\u0001\tE]N4\u0015\r\u001c7cC\u000e\\\u0007k\u001c:uA!Q\u0011qKA \u0005\u0004%I!!\u0017\u0002#%tW\r^*pG.,G/\u00113ee\u0016\u001c8/\u0006\u0002\u0002\\A!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\u0005\u00154\"\u0001\u0003vi&d\u0017\u0002BA5\u0003?\u0012QAU3hKbD\u0011\"!\u001c\u0002@\u0001\u0006I!a\u0017\u0002%%tW\r^*pG.,G/\u00113ee\u0016\u001c8\u000f\t\u0005\n\u0003c\ny\u0004\"\u0001\u0007\u0003g\na\u0003]1sg\u0016t\u0015-\\3tKJ4XM]!eIJ,7o\u001d\u000b\u0004u\u0005U\u0004bBA<\u0003_\u0002\r\u0001\\\u0001\u0004gR\u0014\b\u0006BA8\u0003[A\u0011\"! \u0002@\u0011\u0005a!a \u0002+\u001d,G\u000fR3gCVdGOT1nKN+'O^3sgR!\u0011\u0011QAE!\u0015\t\u0019)!\"/\u001b\t\t\u0019'\u0003\u0003\u0002\b\u0006\r$a\u0001+ss\"1\u0001#a\u001fA\u0002I\u0001")
public final class DnsSettings {
    private final ExtendedActorSystem system;
    private final Config c;
    private final List<InetSocketAddress> NameServers;
    private final FiniteDuration ResolveTimeout;
    private final CachePolicy.CachePolicy PositiveCachePolicy;
    private final CachePolicy.CachePolicy NegativeCachePolicy;
    private Option<ResolvConf> resolvConf;
    private final List<String> SearchDomains;
    private final int NDots;
    private volatile boolean bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option resolvConf$lzycompute() {
        DnsSettings dnsSettings = this;
        synchronized (dnsSettings) {
            if (!this.bitmap$0) {
                None$ none$;
                File etcResolvConf = new File("/etc/resolv.conf");
                if (Helpers$.MODULE$.isWindows()) {
                    none$ = None$.MODULE$;
                } else if (etcResolvConf.exists()) {
                    Some some2;
                    Try<ResolvConf> parsed = ResolvConfParser$.MODULE$.parseFile(etcResolvConf);
                    Try<ResolvConf> try_ = parsed;
                    if (try_ instanceof Success) {
                        Success success2 = (Success)try_;
                        ResolvConf value2 = (ResolvConf)success2.value();
                        some2 = new Some((Object)value2);
                    } else {
                        if (!(try_ instanceof Failure)) throw new MatchError(try_);
                        Failure failure2 = (Failure)try_;
                        Throwable exception = failure2.exception();
                        if (this.system.log().isWarningEnabled()) {
                            this.system.log().error(exception, "Error parsing /etc/resolv.conf, ignoring.");
                        }
                        some2 = None$.MODULE$;
                    }
                    none$ = some2;
                } else {
                    none$ = None$.MODULE$;
                }
                this.resolvConf = none$;
                this.bitmap$0 = true;
            }
            return this.resolvConf;
        }
    }

    public List<InetSocketAddress> NameServers() {
        return this.NameServers;
    }

    public FiniteDuration ResolveTimeout() {
        return this.ResolveTimeout;
    }

    public CachePolicy.CachePolicy PositiveCachePolicy() {
        return this.PositiveCachePolicy;
    }

    public CachePolicy.CachePolicy NegativeCachePolicy() {
        return this.NegativeCachePolicy;
    }

    private CachePolicy.CachePolicy getTtl(String path2) {
        CachePolicy.CachePolicy cachePolicy;
        String string2 = this.c.getString(path2);
        if ("forever".equals(string2)) {
            cachePolicy = CachePolicy$Forever$.MODULE$;
        } else if ("never".equals(string2)) {
            cachePolicy = CachePolicy$Never$.MODULE$;
        } else {
            Duration finiteTtl = Helpers$Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(this.c.getDuration(path2)), new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Duration x$2) {
                    return !x$2.isNegative();
                }
            }, (Function0<Object>)new Serializable(this, path2){
                public static final long serialVersionUID = 0L;
                private final String path$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.io.dns.", " must be 'default', 'forever', 'never' or positive duration"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                }
                {
                    this.path$1 = path$1;
                }
            });
            cachePolicy = CachePolicy$Ttl$.MODULE$.fromPositive(finiteTtl);
        }
        return cachePolicy;
    }

    private Option<ResolvConf> resolvConf() {
        return this.bitmap$0 ? this.resolvConf : this.resolvConf$lzycompute();
    }

    public List<String> SearchDomains() {
        return this.SearchDomains;
    }

    public int NDots() {
        return this.NDots;
    }

    public Nothing$ failUnableToDetermineDefaultNameservers() {
        throw new IllegalStateException("Unable to obtain default nameservers from JNDI or via reflection. Please set `akka.io.dns.async-dns.nameservers` explicitly in order to be able to resolve domain names. ");
    }

    public DnsSettings(ExtendedActorSystem system, Config c) {
        block9: {
            block12: {
                block16: {
                    int n;
                    block15: {
                        ConfigValueType configValueType;
                        block13: {
                            block14: {
                                int n2;
                                List list2;
                                block11: {
                                    ConfigValueType configValueType2;
                                    block10: {
                                        List list3;
                                        block8: {
                                            ConfigValueType configValueType3;
                                            block7: {
                                                List list4;
                                                this.system = system;
                                                this.c = c;
                                                configValueType3 = c.getValue("nameservers").valueType();
                                                if (!((Object)((Object)ConfigValueType.STRING)).equals((Object)configValueType3)) break block7;
                                                String string2 = c.getString("nameservers");
                                                if ("default".equals(string2)) {
                                                    List osAddresses = (List)DnsSettings$.MODULE$.getDefaultNameServers(system).getOrElse((Function0)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ DnsSettings $outer;

                                                        public final Nothing$ apply() {
                                                            return this.$outer.failUnableToDetermineDefaultNameservers();
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    });
                                                    if (osAddresses.isEmpty()) {
                                                        throw this.failUnableToDetermineDefaultNameservers();
                                                    }
                                                    list4 = osAddresses;
                                                } else {
                                                    InetSocketAddress inetSocketAddress = DnsSettings$.MODULE$.parseNameserverAddress(string2);
                                                    list4 = Nil$.MODULE$.$colon$colon((Object)inetSocketAddress);
                                                }
                                                list3 = list4;
                                                break block8;
                                            }
                                            if (!((Object)((Object)ConfigValueType.LIST)).equals((Object)configValueType3)) break block9;
                                            IndexedSeq userAddresses = (IndexedSeq)((IterableLike)package$JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("nameservers")).asScala()).iterator().map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final InetSocketAddress apply(String str) {
                                                    return DnsSettings$.MODULE$.parseNameserverAddress(str);
                                                }
                                            }).to(package$.MODULE$.genericCompanionToCBF(IndexedSeq$.MODULE$));
                                            Predef$.MODULE$.require(userAddresses.nonEmpty(), (Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply() {
                                                    return "nameservers can not be empty";
                                                }
                                            });
                                            list3 = userAddresses.toList();
                                        }
                                        this.NameServers = list3;
                                        this.ResolveTimeout = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c.getDuration("resolve-timeout")));
                                        this.PositiveCachePolicy = this.getTtl("positive-ttl");
                                        this.NegativeCachePolicy = this.getTtl("negative-ttl");
                                        configValueType2 = c.getValue("search-domains").valueType();
                                        if (!((Object)((Object)ConfigValueType.STRING)).equals((Object)configValueType2)) break block10;
                                        String string3 = c.getString("search-domains");
                                        List list5 = "default".equals(string3) ? (List)this.resolvConf().map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final List<String> apply(ResolvConf x$3) {
                                                return x$3.search();
                                            }
                                        }).getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Nil$ apply() {
                                                return Nil$.MODULE$;
                                            }
                                        }) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string3}));
                                        list2 = list5;
                                        break block11;
                                    }
                                    if (!((Object)((Object)ConfigValueType.LIST)).equals((Object)configValueType2)) break block12;
                                    list2 = ((TraversableOnce)package$JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("search-domains")).asScala()).toList();
                                }
                                this.SearchDomains = list2;
                                configValueType = c.getValue("ndots").valueType();
                                if (!((Object)((Object)ConfigValueType.STRING)).equals((Object)configValueType)) break block13;
                                String string4 = c.getString("ndots");
                                if (!"default".equals(string4)) break block14;
                                n = n2 = BoxesRunTime.unboxToInt((Object)this.resolvConf().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(ResolvConf x$4) {
                                        return x$4.ndots();
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return 1;
                                    }
                                }));
                                break block15;
                            }
                            throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
                        }
                        if (!((Object)((Object)ConfigValueType.NUMBER)).equals((Object)configValueType)) break block16;
                        int ndots = c.getInt("ndots");
                        if (ndots < 0) {
                            throw new IllegalArgumentException("Invalid value for ndots, ndots must not be negative.");
                        }
                        n = ndots;
                    }
                    this.NDots = n;
                    return;
                }
                throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            }
            throw new IllegalArgumentException("Invalid type for search-domains. Must be a string or string list.");
        }
        throw new IllegalArgumentException("Invalid type for nameservers. Must be a string or string list");
    }
}

