/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.rm.datasource.undo;

import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.CollectionUtils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * The Type UndoExecutorHolderFactory
 *
 */
public class UndoExecutorHolderFactory {

    private static final Map<String, UndoExecutorHolder> UNDO_EXECUTOR_HOLDER_MAP = new ConcurrentHashMap<>();

    /**
     * Get UndoExecutorHolder by db type
     *
     * @param dbType the db type
     * @return the UndoExecutorGroup
     */
    public static UndoExecutorHolder getUndoExecutorHolder(String dbType) {
        return CollectionUtils.computeIfAbsent(
                UNDO_EXECUTOR_HOLDER_MAP, dbType, key -> EnhancedServiceLoader.load(UndoExecutorHolder.class, dbType));
    }
}
