/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.snapshot.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftSessionSnapshot
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftSessionSnapshot.class);
    private static final long serialVersionUID = -2257327786007900291L;
    private Map<byte[], List<byte[]>> globalsessions = new ConcurrentHashMap();

    public Map<byte[], List<byte[]>> getGlobalsessions() {
        return this.globalsessions;
    }

    public void setGlobalsessions(Map<byte[], List<byte[]>> globalsessions) {
        this.globalsessions = globalsessions;
    }

    public Map<String, GlobalSession> convert2GlobalSession() {
        HashMap<String, GlobalSession> sessionMap = new HashMap<String, GlobalSession>();
        this.globalsessions.forEach((globalSessionByte, branchSessionBytes) -> {
            GlobalSession globalSession = new GlobalSession();
            globalSession.decode(globalSessionByte);
            branchSessionBytes.forEach(branch -> {
                BranchSession branchSession = new BranchSession();
                branchSession.decode(branch);
                if (globalSession.isActive()) {
                    try {
                        branchSession.lock();
                    }
                    catch (TransactionException e) {
                        LOGGER.error(e.getMessage());
                    }
                }
                globalSession.add(branchSession);
            });
            if (GlobalStatus.Rollbacking.equals((Object)globalSession.getStatus()) || GlobalStatus.TimeoutRollbacking.equals((Object)globalSession.getStatus())) {
                globalSession.getBranchSessions().parallelStream().forEach(branchSession -> branchSession.setLockStatus(LockStatus.Rollbacking));
            }
            sessionMap.put(globalSession.getXid(), globalSession);
        });
        return sessionMap;
    }

    public void convert2GlobalSessionByte(GlobalSession globalSession) {
        byte[] globalSessionByte = globalSession.encode();
        if (CollectionUtils.isEmpty((Collection)globalSession.getBranchSessions())) {
            this.globalsessions.put(globalSessionByte, Collections.emptyList());
        } else {
            this.globalsessions.put(globalSessionByte, globalSession.getBranchSessions().parallelStream().map(branch -> branch.encode()).collect(Collectors.toList()));
        }
    }
}

